SELECT CASE
         WHEN XX.DESCRICAO = UPPER(XX.DESCRICAO) THEN 1
         ELSE 0
       END ||' - '||XX.RECEITA||' - '||CURRENT_TIMESTAMP AS KEYITEM,
       XX.*
  FROM (
SELECT X.NIVEL + 1 -
       (SELECT MIN(R.NIVEL)
          FROM ${db.contabilidade.schema}.RECEITA R
         WHERE R.ENTIDADE = :entidade
           AND R.EXERCICIO = :exercicio
           $[FILTRO]) AS NIVEL,
       CASE
         WHEN X.DESCRICAO = UPPER(X.DESCRICAO) THEN X.RECEITA
         ELSE X.RECEITA||' '
       END AS RECEITA,
       X.DESCRICAO,
       X.INICIO,
       X.TAMANHO,
       X.ACEITAMOVIMENTACAO,
       X.VALORORCADO,
       X.VALORATUALIZADO,
       X.VALORARRECADADO,
       X.VALORLANCADO
  FROM (
SELECT SUBSTR(R.RECEITA,1, R.INICIO+TAMANHO-1) AS RECEITA,
       UPPER(R.DESCRICAO) AS DESCRICAO,
       R.NIVEL,
       R.INICIO,
       R.TAMANHO,
       R.MOVSN AS ACEITAMOVIMENTACAO,
       COALESCE(SUM(R.VALORORCADO),0) AS VALORORCADO,
       (COALESCE(SUM(R.VALORORCADO),0) +
       COALESCE(SUM(
          (SELECT SUM(RECM.VALORCORRECAOORCADO)
             FROM ${db.contabilidade.schema}.RECEITAMENSAL RECM
            WHERE R.ENTIDADE = RECM.ENTIDADE
              AND R.EXERCICIO = RECM.EXERCICIO
              AND R.RECEITA = RECM.RECEITA
              AND R.FONTERECURSO = RECM.FONTERECURSO
              AND R.IDTIPOOPERACAORECEITA = RECM.IDTIPOOPERACAORECEITA
              $[FILTRORECEITAMENSAL]
              )),0)) AS VALORATUALIZADO,
       COALESCE(SUM(
          (SELECT SUM(RD.VALORARRECADADO - RD.VALORESTARRECADADO - RD.VALORDEVOLUCAO + RD.VALORESTDEVOLUCAO)
             FROM ${db.contabilidade.schema}.RECEITADIARIA RD
            WHERE R.ENTIDADE = RD.ENTIDADE
              AND R.EXERCICIO = RD.EXERCICIO
              AND R.RECEITA = RD.RECEITA
              AND R.FONTERECURSO = RD.FONTERECURSO
              AND R.IDTIPOOPERACAORECEITA = RD.IDTIPOOPERACAORECEITA
              $[FILTRORECEITADIARIA]
          )),0) AS VALORARRECADADO,
       COALESCE(
          (SELECT COALESCE(SUM(B.VALOR),0)
             FROM ${db.contabilidade.schema}.EVENTOSLANCADOS A
             LEFT JOIN ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA B
               ON A.ENTIDADE      = B.ENTIDADE
              AND A.EXERCICIO     = B.EXERCICIO
              AND A.TIPOEVENTO    = B.TIPOEVENTO
              AND A.GRUPOEVENTO   = B.GRUPOEVENTO
              AND A.EVENTO        = B.EVENTO
              AND A.NROLANCAMENTO = B.NROLANCAMENTO
              AND B.DEBCRED = 'D'
             LEFT JOIN ${db.contabilidade.schema}.TABELAEVENTO  C
               ON C.ENTIDADE  = A.ENTIDADE
              AND C.EXERCICIO = A.EXERCICIO
              AND C.TIPOEVENTO  = A.TIPOEVENTO
              AND C.GRUPOEVENTO = A.GRUPOEVENTO
              AND C.EVENTO      = A.EVENTO
            WHERE A.ENTIDADE    = :entidade
              AND A.EXERCICIO   = :exercicio
              AND A.NRODOCUMENTOORIGEM LIKE '%Receita: '||SUBSTR(R.RECEITA,1, R.INICIO+TAMANHO-1)||'%'
              AND C.GRUPOEVENTO = 100
              AND C.EVENTO = 1),0) AS VALORLANCADO
  FROM ${db.contabilidade.schema}.RECEITA R
 WHERE R.ENTIDADE = :entidade
   AND R.EXERCICIO = :exercicio
       $[FILTRO]
 GROUP BY SUBSTR(R.RECEITA,1, R.INICIO+TAMANHO-1),R.RECEITA, R.DESCRICAO, R.NIVEL, R.INICIO, R.TAMANHO, R.MOVSN
 ORDER BY SUBSTR(R.RECEITA,1, R.INICIO+TAMANHO-1), R.DESCRICAO) X
ORDER BY X.RECEITA || CASE
                        WHEN X.DESCRICAO = UPPER(X.DESCRICAO) THEN ''
                        ELSE 'A'
                      END) XX
