SELECT DISTINCT(SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO)) AS CODIGO,
(SELECT DISTINCT(PARAM.DESCRICAO)
   FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA PARAM
  WHERE PARAM.ENTIDADE = DESP.ENTIDADE
    AND PARAM.EXERCICIO = DESP.EXERCICIO
    AND PARAM.MODELODESPESA = DESP.MODELODESPESA
    AND PARAM.TIPO = ORG.TIPO
    AND PARAM.ORDEM = ORG.ORDEM
    AND PARAM.CODIGO = SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO)) AS DESCRICAO
  FROM ${db.contabilidade.schema}.EMPENHO E
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESA DESP
    ON E.ENTIDADE = DESP.ENTIDADE
   AND E.EXERCICIO = DESP.EXERCICIO
   AND E.PROGRAMATICA = DESP.PROGRAMATICA
   AND E.FONTERECURSO = DESP.FONTERECURSO
  LEFT OUTER JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA ORG
    ON DESP.MODELODESPESA = ORG.MODELODESPESA
   AND ORG.TIPO = 'P'
   AND ORG.ORDEM = 1
 WHERE E.ENTIDADE = :entidade
   AND E.EXERCICIO = :exercicio
   AND DESP.PROGRAMATICA IS NOT NULL