SELECT X.NOME,
       X.CNPJCPF,
       X.FORNECEDOR,
       SUM(X.EMPENHADO) AS EMPENHADO,
       SUM(X.ANULADO) AS ANULADO,
       SUM(X.LIQUIDADO) AS LIQUIDADO,
       SUM(X.RETIDO) AS RETIDO,
       SUM(X.PAGO) AS PAGO,
       SUM(X.EMPENHADO - X.ANULADO - X.RETIDO - X.PAGO) AS APAGAR
  FROM (SELECT E.EXERCICIO,
               E.EMPENHO,
               F.NOME,
               CASE
                 WHEN F.TIPOPESSOA = 'F' THEN
                  '****' || SUBSTR(F.CNPJ, 5, 3) || '****'
                 ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2)
               END AS CNPJCPF,
               F.FORNECEDOR,
               SUM(FE.VALOR) AS EMPENHADO,
               SUM(FE.VALORANULACOES - FE.VALORESTANULACOES) AS ANULADO,
               SUM(FE.VALORLIQUIDACOES - FE.VALORESTLIQUIDACOES) AS LIQUIDADO,
               SUM(FE.VALORRETENCOES) AS RETIDO,
               SUM(FE.VALORPAGAMENTO - FE.VALORESTPAGAMENTO) AS PAGO
          FROM ${db.contabilidade.schema}.EMPENHO E
          LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F ON E.FORNECEDOR = F.FORNECEDOR
          LEFT OUTER JOIN ${db.contabilidade.schema}.FICHAEMPENHO FE ON E.ENTIDADE = FE.ENTIDADE
		        AND E.EXERCICIO = FE.EXERCICIO
		        AND E.EMPENHO = FE.EMPENHO
		        AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA
          $[FILTRO]
         GROUP BY E.EXERCICIO,
                  E.EMPENHO,
                  F.NOME,
                  CASE
                    WHEN F.TIPOPESSOA = 'F' THEN
                     '****' || SUBSTR(F.CNPJ, 5, 3) || '****'
                    ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2)
                  END,
                  F.FORNECEDOR) X
WHERE (X.EMPENHADO - X.ANULADO - X.RETIDO - X.PAGO) >= 0.01
 GROUP BY X.NOME, X.CNPJCPF, X.FORNECEDOR
