SELECT 
       L.ENTIDADE,
       L.ANODOCORIGEM AS EXERCICIO,
       L.NODOCORIGEM AS EMPENHO,
       L.UNIDADEDOCORIGEM AS UNIDADEORCAMENTARIA,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       L.DATA,
       L.VALOR,
       (SELECT COALESCE(SUM(EL.VALOR), 0)                                     
          FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO EL
         WHERE EL.ENTIDADE         = L.ENTIDADE                               
           AND EL.EXERCICIOLIQ     = L.EXERCICIO                              
           AND EL.TIPODOCORIGEM    = L.TIPODOCORIGEM                          
           AND EL.ANODOCORIGEM     = L.ANODOCORIGEM                           
           AND EL.NODOCORIGEM      = L.NODOCORIGEM                            
           AND EL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM                       
           AND EL.NOLIQUIDACAO     = L.NOLIQUIDACAO) AS VALORESTORNADO,
       (SELECT COALESCE(SUM(R.VALOR), 0)
          FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_RETENCAO R
          LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO OP
            ON OP.ENTIDADE  = R.ENTIDADE
           AND OP.EXERCICIO = R.EXERCICIO
           AND OP.NOORDEM   = R.NOORDEM
         WHERE OP.CANCELADO       = 'P'
           AND R.ENTIDADE         = L.ENTIDADE
           AND R.EXERCICIOLIQ     = L.EXERCICIO
           AND R.TIPODOCORIGEM    = L.TIPODOCORIGEM
           AND R.ANODOCORIGEM     = L.ANODOCORIGEM
           AND R.NODOCORIGEM      = L.NODOCORIGEM
           AND R.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
           AND R.NOLIQUIDACAO     = L.NOLIQUIDACAO) AS VALORRETIDO,
       (SELECT COALESCE(SUM(OPL.VALOR), 0)                                      
          FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OPL
          LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO OP
            ON OP.ENTIDADE  = OPL.ENTIDADE
           AND OP.EXERCICIO = OPL.EXERCICIO
           AND OP.NOORDEM   = OPL.NOORDEM                           
         WHERE OP.CANCELADO         = 'P'
           AND OPL.ENTIDADE         = L.ENTIDADE                              
           AND OPL.EXERCICIOLIQ     = L.EXERCICIO                             
           AND OPL.TIPODOCORIGEM    = L.TIPODOCORIGEM                         
           AND OPL.ANODOCORIGEM     = L.ANODOCORIGEM                          
           AND OPL.NODOCORIGEM      = L.NODOCORIGEM                           
           AND OPL.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM                      
           AND OPL.NOLIQUIDACAO     = L.NOLIQUIDACAO) AS VALORPAGO              
  FROM ${db.contabilidade.schema}.EMPENHO E
  JOIN ${db.contabilidade.schema}.LIQUIDACAO L
    ON L.ENTIDADE         = E.ENTIDADE
   AND L.TIPODOCORIGEM    = 'E'
   AND L.ANODOCORIGEM     = E.EXERCICIO
   AND L.NODOCORIGEM      = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
