SELECT P.NODOCUMENTO AS NUMERO,
       P.SEQUENCIA AS ID,
       T.DESCRICAO AS TIPODOCUMENTOFISCAL,
       COALESCE(S.DSTIPOSERIEDOCFISCAL, P.SERIE) AS TIPOSERIEDOCUMENTOFISCAL,
       P.DATA,
       COALESCE(P.FORNECEDOR,0) AS FORNECEDOR,
       P.VALOR
  FROM ${db.contabilidade.schema}.PRESTACAOCONTASDOCUMENTO P
  LEFT JOIN ${db.contabilidade.schema}.TIPODOCFISCAL T
    ON T.ENTIDADE  = P.ENTIDADE
   AND T.EXERCICIO = P.EXERCICIO
   AND T.TIPO      = P.TIPODOCUMENTO
  LEFT JOIN ${db.contabilidade.schema}.TIPOSERIEDOCFISCAL S
    ON CAST(S.CODIGO AS VARCHAR(10)) = P.SERIE 	
 WHERE P.ENTIDADE          = :entidade
   AND P.EXERCICIO         = :exercicio
   AND P.PRESTACAOCONTAS   = :prestacaoContas
 ORDER BY P.SEQUENCIA