SELECT CASE 
         WHEN X.ESFERA = 'I' THEN 'Investimentos'
         WHEN X.ESFERA = 'S' THEN 'Seguridade'
         WHEN X.ESFERA = 'F' THEN 'Fiscal'
       END AS DESCRICAO,
       X.VALORDECRETO + (SELECT SUM(D.VALORPREVISTO)
                           FROM ${db.contabilidade.schema}.DESPESA D
                          WHERE D.ENTIDADE = X.ENTIDADE
                            AND D.EXERCICIO = X.EXERCICIO
                            AND D.ESFERA = X.ESFERA
                            AND D.MOVSN='S') AS VALORORCADO,
       X.VALOREMPENHADO,
       X.VALORLIQUIDADO,
       X.VALORRETIDO,
       X.VALORPAGO
FROM (
SELECT A.ENTIDADE,
       A.EXERCICIO,
       A.ESFERA,
       COALESCE(SUM(D.VALORSUPLEMENTACAO - D.VALORESTSUPLEMENTACAO -
                    D.VALORREDUCAO + D.VALORESTREDUCAO),0) AS valorDecreto,
       COALESCE(SUM(D.VALOREMPENHO-D.VALORANULACAOEMPENHO+D.VALORESTANULACAOEMPENHO),0) AS valorEmpenhado,
       COALESCE(SUM(D.VALORLIQUIDACAO-D.VALORESTLIQUIDACAO),0) AS valorLiquidado,
       COALESCE(SUM(D.VALORRETENCAO),0) AS valorRetido,
       COALESCE(SUM(D.VALORPAGAMENTO-D.VALORESTPAGAMENTO),0) AS valorPago
  FROM ${db.contabilidade.schema}.DESPESA A
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSO F
    ON F.FONTERECURSO = A.FONTERECURSO
  LEFT JOIN ${db.contabilidade.schema}.DESPESAMENSAL D
    ON A.ENTIDADE = D.ENTIDADE
   AND A.EXERCICIO = D.EXERCICIO
   AND A.PROGRAMATICA = D.PROGRAMATICA
   AND A.FONTERECURSO = D.FONTERECURSO
 WHERE A.ENTIDADE = ?
   AND A.EXERCICIO = ?
   AND A.MOVSN = 'S'
 GROUP BY A.ENTIDADE, A.EXERCICIO, A.ESFERA
) X
ORDER BY X.ESFERA