/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.rest.params;

import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FornecedorAPagarParams {
    private Long entidade;
    private Long exercicio;
    private String nome;
    private String cnpjCpf;
    private String exportType;

    public String montaFiltro() {
        StringBuilder where = new StringBuilder();
        where.append(" WHERE E.ENTIDADE = ").append(this.entidade.intValue());
        where.append(" AND E.CONTABILIZADO = 'S'");
        if (this.nome != null && !this.nome.trim().equals("")) {
            where.append(" AND UPPER(F.NOME) LIKE UPPER('").append(SqlUtils.toSqlLike((String)this.nome)).append("')");
        }
        if (this.cnpjCpf != null && !this.cnpjCpf.trim().equals("")) {
            where.append(" AND (F.CNPJ = '").append(StringUtils.somenteNumeros((String)this.getCnpjCpf())).append("')");
        }
        return where.toString();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (this.entidade != null) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
        return params;
    }

    public String getCnpjCpf() {
        return StringUtils.somenteNumeros((String)this.cnpjCpf);
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }
}

