/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.rest.params;

import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class ComprasDiretaParams {
    private Long entidade;
    private Long exercicio;
    private String nome;
    private String cnpjCpf;
    private String exportType;

    public String montaFiltro() {
        StringBuilder where = new StringBuilder();
        where.append(" AND E.ENTIDADE = ").append(this.entidade.intValue());
        where.append(" AND E.EXERCICIO = ").append(this.exercicio.intValue());
        where.append(" AND E.CONTABILIZADO = 'S'");
        if (Objects.nonNull(this.nome) && !this.nome.trim().equals("")) {
            where.append(" AND UPPER(F.NOME) LIKE UPPER('").append(SqlUtils.toSqlLike((String)this.nome)).append("')");
        }
        if (Objects.nonNull(this.cnpjCpf) && !this.cnpjCpf.trim().equals("")) {
            where.append(" AND (F.CNPJ = '").append(this.cnpjCpf).append("')");
        }
        return where.toString();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
        return params;
    }

    @Generated
    public ComprasDiretaParams() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComprasDiretaParams)) {
            return false;
        }
        ComprasDiretaParams other = (ComprasDiretaParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComprasDiretaParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComprasDiretaParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", nome=" + this.getNome() + ", cnpjCpf=" + this.getCnpjCpf() + ", exportType=" + this.getExportType() + ")";
    }
}

