/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.utils;

import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RsqlToJdbcParams {
    private RsqlToJdbcParams() {
    }

    public static Map<String, Object> parse(String rsql) {
        if (rsql == null || rsql.isBlank()) {
            return Collections.emptyMap();
        }
        Node root = new RSQLParser().parse(rsql);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        RsqlToJdbcParams.collect((Node)root, params);
        return params;
    }

    private static void collect(Node node, Map<String, Object> out) {
        if (node instanceof AndNode) {
            ((AndNode)node).getChildren().forEach(child -> RsqlToJdbcParams.collect((Node)child, (Map)out));
        } else if (node instanceof OrNode) {
            ((OrNode)node).getChildren().forEach(child -> RsqlToJdbcParams.collect((Node)child, (Map)out));
        } else if (node instanceof ComparisonNode) {
            RsqlToJdbcParams.handleComparison((ComparisonNode)((ComparisonNode)node), out);
        }
    }

    private static void handleComparison(ComparisonNode cmp, Map<String, Object> out) {
        List args = cmp.getArguments();
        if (args == null || args.isEmpty()) {
            return;
        }
        String selector = cmp.getSelector();
        String base = selector.replace('.', '_');
        if (args.size() == 1) {
            String raw = (String)args.get(0);
            boolean hasWildcard = raw.indexOf(42) >= 0;
            Object val = RsqlToJdbcParams.castAndNormalize((String)raw, (boolean)hasWildcard);
            String pname = RsqlToJdbcParams.uniqueParamName(out, (String)base);
            out.put(pname, val);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            for (String a : args) {
                boolean hasWildcard = a.indexOf(42) >= 0;
                list.add(RsqlToJdbcParams.castAndNormalize((String)a, (boolean)hasWildcard));
            }
            String pname = RsqlToJdbcParams.uniqueParamName(out, (String)base);
            out.put(pname, list);
        }
    }

    private static String uniqueParamName(Map<String, Object> out, String base) {
        Object name = base;
        int i = 1;
        while (out.containsKey(name)) {
            name = base + "_" + i++;
        }
        return name;
    }

    private static Object castAndNormalize(String raw, boolean hasWildcard) {
        if (raw == null) {
            return null;
        }
        String t = raw.trim();
        if (t.startsWith("'") && t.endsWith("'") || t.startsWith("\"") && t.endsWith("\"")) {
            t = t.substring(1, t.length() - 1);
        }
        if (hasWildcard) {
            return t.replace('*', '%');
        }
        if (t.matches("^-?\\d+$")) {
            try {
                return Long.parseLong(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (t.matches("^-?\\d+\\.\\d+$")) {
            try {
                return Double.parseDouble(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }
}

