/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.sei.service;

import br.com.elotech.gatewayprocessos.client.dto.IncluirDocumentoByteDTO;
import br.com.elotech.gatewayprocessos.client.dto.IncluirProcessoSEIDTO;
import br.com.elotech.gatewayprocessos.client.dto.InteressadoDTO;
import br.com.elotech.gatewayprocessos.client.dto.NivelAcesso;
import br.com.elotech.gatewayprocessos.client.dto.NovoDocumentoDTO;
import br.com.elotech.gatewayprocessos.client.dto.NovoProcessoDTO;
import br.com.elotech.gatewayprocessos.client.dto.ProcessoDTO;
import br.com.elotech.gatewayprocessos.client.dto.ProcessoParams;
import br.com.elotech.gatewayprocessos.client.feign.ProcessoFeignClient;
import br.com.elotech.gatewayprocessos.client.feign.ProcessoSEIFeignClient;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.exception.ParametroMalConfiguradoException;
import br.com.elotech.portaltransparencia.protocportal.params.SalvaProcessoParams;
import br.com.elotech.portaltransparencia.sei.ProcessoSeiDTO;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.ws.rs.BadRequestException;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.stereotype.Service;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Service
public class ProcessoSeiService {
    private final ProcessoSEIFeignClient processoSEIFeignClient;
    private final ProcessoFeignClient processoFeignClient;
    private final PortalParametroRepository portalParametroRepository;
    private static final List<Long> PARAMETROS_ESIC = List.of(Parametros.PARAM_ID_UNIDADE_SEI, Parametros.PARAM_ID_TIPO_PROCEDIMENTO_SEI, Parametros.PARAM_CODIGO_TIPO_SERIE_SEI, Parametros.PARAM_TEMPLATE_DOCUMENTO_SEI, Parametros.PARAM_NIVEL_ACESSO_PROCEDIMENTO_SEI, Parametros.PARAM_ID_HIPOTESE_LEGAL_SEI, Parametros.PARAM_INTERESSADOS_PROCESSO_SEI);

    public ProcessoSeiDTO salvarProcesso(@Valid SalvaProcessoParams params) {
        PortalParametroContabil parametroInteressados;
        this.validarEmail(params.getPessoa().getContato().getEmail());
        Map parametrosSei = this.portalParametroRepository.findAllByEntidadeExercicioAndIdsParametrosIn(params.getEntidade(), params.getExercicio(), PARAMETROS_ESIC).stream().collect(Collectors.toMap(PortalParametroContabil::getIdParametro, Function.identity()));
        this.validarParametros(parametrosSei, params.getEntidade(), params.getExercicio());
        IncluirProcessoSEIDTO incluirProcessoSEIDTO = new IncluirProcessoSEIDTO();
        incluirProcessoSEIDTO.setIdEntidade(params.getEntidade());
        incluirProcessoSEIDTO.setIdUnidadeSei(((PortalParametroContabil)parametrosSei.get(Parametros.PARAM_ID_UNIDADE_SEI)).getValor());
        incluirProcessoSEIDTO.setIdTipoProcedimento(((PortalParametroContabil)parametrosSei.get(Parametros.PARAM_ID_TIPO_PROCEDIMENTO_SEI)).getValor());
        incluirProcessoSEIDTO.setEspecificacao(params.getAssunto());
        PortalParametroContabil paramNivelAcesso = (PortalParametroContabil)parametrosSei.get(Parametros.PARAM_NIVEL_ACESSO_PROCEDIMENTO_SEI);
        if (Objects.nonNull(paramNivelAcesso) && StringUtils.isNotBlank((CharSequence)((PortalParametroContabil)parametrosSei.get(Parametros.PARAM_NIVEL_ACESSO_PROCEDIMENTO_SEI)).getValor())) {
            incluirProcessoSEIDTO.setNivelAcesso(NivelAcesso.from((String)((PortalParametroContabil)parametrosSei.get(Parametros.PARAM_NIVEL_ACESSO_PROCEDIMENTO_SEI)).getValor()));
            PortalParametroContabil idHipoteseLegal = (PortalParametroContabil)parametrosSei.get(Parametros.PARAM_ID_HIPOTESE_LEGAL_SEI);
            if (!NivelAcesso.PUBLICO.equals((Object)incluirProcessoSEIDTO.getNivelAcesso()) && Objects.nonNull(idHipoteseLegal)) {
                incluirProcessoSEIDTO.setIdHipoteseLegal(idHipoteseLegal.getValor());
            }
        }
        if (Objects.nonNull(parametroInteressados = (PortalParametroContabil)parametrosSei.get(Parametros.PARAM_INTERESSADOS_PROCESSO_SEI)) && StringUtils.isNotBlank((CharSequence)parametroInteressados.getValor())) {
            String[] nomesInteressados = parametroInteressados.getValor().split(",");
            incluirProcessoSEIDTO.getInteressados().addAll(Arrays.stream(nomesInteressados).filter(StringUtils::isNotBlank).map(InteressadoDTO::new).toList());
        }
        NovoProcessoDTO processo = this.processoSEIFeignClient.create(incluirProcessoSEIDTO);
        IncluirDocumentoByteDTO incluirDocumentoByteDTO = new IncluirDocumentoByteDTO();
        incluirDocumentoByteDTO.setIdEntidade(params.getEntidade());
        incluirDocumentoByteDTO.setUnidadeSei(((PortalParametroContabil)parametrosSei.get(Parametros.PARAM_ID_UNIDADE_SEI)).getValor());
        incluirDocumentoByteDTO.setIdSerieSEI(((PortalParametroContabil)parametrosSei.get(Parametros.PARAM_CODIGO_TIPO_SERIE_SEI)).getValor());
        incluirDocumentoByteDTO.setNumeroProcesso(processo.getNumeroProcesso());
        incluirDocumentoByteDTO.setNomeArquivo("Formul\u00e1rio de Acesso \u00e0 Informa\u00e7\u00e3o.pdf");
        incluirDocumentoByteDTO.setArquivo(this.htmlToPdf(this.parseTemplate(((PortalParametroContabil)parametrosSei.get(Parametros.PARAM_TEMPLATE_DOCUMENTO_SEI)).getValor(), params)));
        NovoDocumentoDTO documento = this.processoFeignClient.incluirDocumentoByte(incluirDocumentoByteDTO);
        return ProcessoSeiDTO.builder().idProcesso(processo.getIdProcesso()).numeroProcesso(processo.getNumeroProcesso()).idDocumento(documento.getIdDocumento()).numeroDocumento(documento.getNumeroDocumento()).linkDocumento(documento.getLink()).build();
    }

    private void validarEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            throw new BadRequestException("E-mail \u00e9 obrigat\u00f3rio.");
        }
        String regex = "^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,6}$";
        if (!email.matches(regex)) {
            throw new BadRequestException("Digite um e-mail v\u00e1lido.");
        }
    }

    private void validarParametros(Map<Long, PortalParametroContabil> parametrosSei, Long entidade, Long exercicio) {
        if (!this.isParametroPreenchido(parametrosSei, Parametros.PARAM_ID_UNIDADE_SEI)) {
            throw new ParametroMalConfiguradoException(entidade, exercicio, Parametros.PARAM_ID_UNIDADE_SEI, "Id da unidade do Sei");
        }
        if (!this.isParametroPreenchido(parametrosSei, Parametros.PARAM_ID_TIPO_PROCEDIMENTO_SEI)) {
            throw new ParametroMalConfiguradoException(entidade, exercicio, Parametros.PARAM_ID_TIPO_PROCEDIMENTO_SEI, "Id do tipo de procedimento do Sei");
        }
        if (!this.isParametroPreenchido(parametrosSei, Parametros.PARAM_CODIGO_TIPO_SERIE_SEI)) {
            throw new ParametroMalConfiguradoException(entidade, exercicio, Parametros.PARAM_CODIGO_TIPO_SERIE_SEI, "C\u00f3digo do tipo de s\u00e9rie do Sei");
        }
        if (!this.isParametroPreenchido(parametrosSei, Parametros.PARAM_TEMPLATE_DOCUMENTO_SEI)) {
            throw new ParametroMalConfiguradoException(entidade, exercicio, Parametros.PARAM_TEMPLATE_DOCUMENTO_SEI, "Template de documento do Sei");
        }
    }

    private boolean isParametroPreenchido(Map<Long, PortalParametroContabil> parametrosSei, Long idParametro) {
        return Optional.ofNullable(parametrosSei.get(idParametro)).map(PortalParametroContabil::getValor).filter(StringUtils::isNotBlank).isPresent();
    }

    public String parseTemplate(String template, SalvaProcessoParams params) {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        dados.put("pessoa", params.getPessoa());
        dados.put("nome", params.getPessoa().getNome());
        Optional.ofNullable(params.getPessoa().getContato()).ifPresent(contato -> {
            dados.put("email", contato.getEmail());
            dados.put("celular", contato.getCelular());
            dados.put("telefone", contato.getCelular());
        });
        Optional.ofNullable(params.getEndereco()).ifPresent(endereco -> {
            dados.put("logradouro", endereco.getEndereco());
            dados.put("numero", endereco.getNumero());
            dados.put("bairro", endereco.getBairroAux());
            dados.put("cep", endereco.getCep());
            dados.put("cidade", endereco.getCidadeAux());
            dados.put("uf", endereco.getUf().getId());
            dados.put("complemento", endereco.getComplemento());
        });
        dados.put("rg", params.getPessoa().getRg());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        LocalDate dataNascimento = params.getDataNascimento();
        String dataNascimentoFormatada = Objects.nonNull(dataNascimento) ? dataNascimento.format(formatter) : "";
        dados.put("dataNascimento", dataNascimentoFormatada);
        dados.put("sexo", params.getSexo());
        dados.put("endereco", params.getEndereco());
        dados.put("assunto", params.getAssunto());
        dados.put("numProtocolo", params.getProtocoloRecurso());
        dados.put("formaRecebimento", params.getFormaRecebimento());
        dados.put("descricao", params.getDigitacao());
        dados.put("url", params.getUrl());
        dados.put("entidade", params.getEntidade());
        dados.put("exercicio", params.getExercicio());
        dados.replaceAll((k, v) -> ObjectUtils.defaultIfNull((Object)v, (Object)""));
        StringSubstitutor substitutor = new StringSubstitutor(dados, "${", "}");
        return substitutor.replace(template);
    }

    public byte[] htmlToPdf(String inputHtml) {
        String fullHtml = String.format("<html lang=\"pt-BR\">\n<body>\n<h3 style=\"text-align: center;\">FORMUL\u00c1RIO PARA PEDIDO DE ACESSO \u00c0 INFORMA\u00c7\u00c3O - PORTAL DA TRANSPAR\u00caNCIA</h3>\n<div>\n%s\n</div>\n</body>\n</html>\n", inputHtml);
        Document document = Jsoup.parse((String)fullHtml, (String)"UTF-8");
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ITextRenderer renderer = new ITextRenderer();
        SharedContext sharedContext = renderer.getSharedContext();
        sharedContext.setPrint(true);
        sharedContext.setInteractive(false);
        String html = document.html();
        renderer.setDocumentFromString(html);
        renderer.layout();
        renderer.createPDF((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    public ProcessoDTO findProcesso(ProcessoParams processoParams) {
        processoParams.setIncluirAndamentos(Boolean.TRUE);
        return this.processoSEIFeignClient.find(processoParams);
    }

    @Generated
    public ProcessoSeiService(ProcessoSEIFeignClient processoSEIFeignClient, ProcessoFeignClient processoFeignClient, PortalParametroRepository portalParametroRepository) {
        this.processoSEIFeignClient = processoSEIFeignClient;
        this.processoFeignClient = processoFeignClient;
        this.portalParametroRepository = portalParametroRepository;
    }
}

