/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.service;

import br.com.elotech.portaltransparencia.saude.domain.dto.EscalaDTO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class EscalaProfissionalService {
    private final RestTemplate restTemplate;
    @Value(value="${elotech.sistemaSaude.url:}")
    private String urlSaude;
    @Value(value="${elotech.sistemaSaude.enabled:false}")
    private Boolean sistemaSaude;

    public EscalaProfissionalService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public List<EscalaDTO> findEstabelecimentos() {
        if (Boolean.FALSE.equals(this.sistemaSaude) || this.urlSaude.isEmpty()) {
            return new ArrayList<EscalaDTO>();
        }
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/escalas/", this.urlSaude));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, EscalaDTO[].class);
            return Arrays.asList(Objects.requireNonNull((EscalaDTO[])responseEntity.getBody()));
        }
        catch (HttpClientErrorException e) {
            return new ArrayList<EscalaDTO>();
        }
    }

    public EscalaDTO getArquivo(Long id) {
        URI uri = URI.create(String.format("%s/WebSocialSaude/rest/saude/escalas/%d", this.urlSaude, id));
        RequestEntity requestEntity = RequestEntity.get((URI)uri).build();
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, EscalaDTO[].class);
        List<EscalaDTO> escalas = Arrays.asList(Objects.requireNonNull((EscalaDTO[])responseEntity.getBody()));
        return escalas.get(0);
    }
}

