/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.protocportal.domain.EstatisticaEsicMensal;
import br.com.elotech.portaltransparencia.protocportal.dto.EstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.RelatorioAnualEstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.SerieItemDTO;
import br.com.elotech.portaltransparencia.protocportal.repository.EstatisticaRepository;
import br.com.elotech.portaltransparencia.protocportal.resource.params.EstatisticaParams;
import br.com.elotech.portaltransparencia.protocportal.service.EstatisticaEsicManualService;
import br.com.elotech.portaltransparencia.protocportal.service.EstatisticaService;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class EstatisticaServiceImpl
implements EstatisticaService {
    private final EstatisticaRepository repository;
    private final PortalParametroService portalParametroService;
    private final EstatisticaEsicManualService estatisticaEsicManualService;

    public EstatisticaServiceImpl(EstatisticaRepository repository, PortalParametroService portalParametroService, EstatisticaEsicManualService estatisticaEsicManualService) {
        this.repository = repository;
        this.portalParametroService = portalParametroService;
        this.estatisticaEsicManualService = estatisticaEsicManualService;
    }

    private boolean isEstatisticaManualAtiva(Long entidade) {
        String valor = this.portalParametroService.getPortalParametroValor(entidade, Long.valueOf(ContextHolder.getHeaderValueExercicio().intValue()), Parametros.PARAM_ESTATISTICAS_ESIC_MANUAL);
        return SimNao.toBoolean((String)valor);
    }

    public BigDecimal getMediaResposta(EstatisticaParams params) {
        if (this.isEstatisticaManualAtiva(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE))) {
            return BigDecimal.ZERO;
        }
        return this.repository.getMediaResposta(params);
    }

    public List<EstatisticaDTO> findEstatisticas(EstatisticaParams params) {
        if (this.isEstatisticaManualAtiva(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE))) {
            return this.findEstatisticasManuais(params);
        }
        return this.repository.findEstatisticas(params);
    }

    public List<SerieItemDTO> findProcessosPorGenero(EstatisticaParams params) {
        if (this.isEstatisticaManualAtiva(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE))) {
            return this.findGeneroManual(params);
        }
        return this.repository.findProcessosPorGenero(params);
    }

    public List<SerieItemDTO> findProcessosPorIdade(EstatisticaParams params) {
        if (this.isEstatisticaManualAtiva(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE))) {
            return this.findIdadeManual(params);
        }
        return this.repository.findProcessosPorIdade(params);
    }

    public List<SerieItemDTO> findProcessosPorEscolaridade(EstatisticaParams params) {
        if (this.isEstatisticaManualAtiva(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE))) {
            return this.findEscolaridadeManual(params);
        }
        return this.repository.findProcessosPorEscolaridade(params);
    }

    public List<RelatorioAnualEstatisticaDTO> findRelatorioAnual(EstatisticaParams params) {
        List estatistica = this.findEstatisticas(params);
        Integer pedidos = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getPedidos()), Integer::sum);
        Integer atendidos = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getAtendidos()), Integer::sum);
        Integer cancelados = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getCancelados()), Integer::sum);
        Integer indeferidos = estatistica.stream().reduce(0, (a, b) -> Math.toIntExact((long)a.intValue() + b.getIndeferidos()), Integer::sum);
        return List.of(RelatorioAnualEstatisticaDTO.of((String)"Pedidos", (Integer)pedidos), RelatorioAnualEstatisticaDTO.of((String)"Atendidos", (Integer)atendidos), RelatorioAnualEstatisticaDTO.of((String)"Cancelados", (Integer)cancelados), RelatorioAnualEstatisticaDTO.of((String)"Indeferidos", (Integer)indeferidos));
    }

    private List<EstatisticaDTO> findEstatisticasManuais(EstatisticaParams params) {
        List estatisticasManuais = params.getExercicio().isPresent() ? this.estatisticaEsicManualService.findMensalByEntidadeAndExercicio(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE), (Long)params.getExercicio().get()) : this.estatisticaEsicManualService.findMensalByEntidade(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE));
        return estatisticasManuais.stream().map(arg_0 -> this.convertToEstatisticaDTO(arg_0)).sorted(Comparator.comparing(EstatisticaDTO::getMes)).collect(Collectors.toList());
    }

    private EstatisticaDTO convertToEstatisticaDTO(EstatisticaEsicMensal mensal) {
        EstatisticaDTO dto = new EstatisticaDTO();
        dto.setExercicio(mensal.getExercicio());
        dto.setMes(Long.valueOf(mensal.getMes().intValue()));
        dto.setPedidos(Long.valueOf(mensal.getPedidos().intValue()));
        dto.setAtendidos(Long.valueOf(mensal.getAtendidos().intValue()));
        dto.setCancelados(Long.valueOf(mensal.getCancelados().intValue()));
        dto.setIndeferidos(Long.valueOf(mensal.getIndeferidos().intValue()));
        return dto;
    }

    private List<SerieItemDTO> findGeneroManual(EstatisticaParams params) {
        Long exercicio = params.getExercicio().orElse(null);
        if (exercicio == null) {
            return List.of();
        }
        List estatisticas = this.estatisticaEsicManualService.findGeneroByEntidadeAndExercicio(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE), exercicio);
        return estatisticas.stream().map(e -> {
            SerieItemDTO dto = new SerieItemDTO();
            dto.setLabel(e.getGenero().getDescricao());
            dto.setValue(BigDecimal.valueOf(e.getQuantidade().intValue()));
            return dto;
        }).collect(Collectors.toList());
    }

    private List<SerieItemDTO> findIdadeManual(EstatisticaParams params) {
        Long exercicio = params.getExercicio().orElse(null);
        if (exercicio == null) {
            return List.of();
        }
        List estatisticas = this.estatisticaEsicManualService.findIdadeByEntidadeAndExercicio(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE), exercicio);
        return estatisticas.stream().sorted(Comparator.comparing(e -> e.getFaixaEtaria().getOrdem())).map(e -> {
            SerieItemDTO dto = new SerieItemDTO();
            dto.setLabel(e.getFaixaEtaria().getDescricao());
            dto.setValue(BigDecimal.valueOf(e.getQuantidade().intValue()));
            return dto;
        }).collect(Collectors.toList());
    }

    private List<SerieItemDTO> findEscolaridadeManual(EstatisticaParams params) {
        Long exercicio = params.getExercicio().orElse(null);
        if (exercicio == null) {
            return List.of();
        }
        List estatisticas = this.estatisticaEsicManualService.findEscolaridadeByEntidadeAndExercicio(params.getEntidade().orElse(Parametros.NAO_DEPENDE_ENTIDADE), exercicio);
        return estatisticas.stream().sorted(Comparator.comparing(e -> e.getEscolaridade().getOrdem())).map(e -> {
            SerieItemDTO dto = new SerieItemDTO();
            dto.setLabel(e.getEscolaridade().getDescricao());
            dto.setValue(BigDecimal.valueOf(e.getQuantidade().intValue()));
            return dto;
        }).collect(Collectors.toList());
    }
}

