/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.resource;

import br.com.elotech.portaltransparencia.protocportal.domain.EstatisticaEsicEscolaridade;
import br.com.elotech.portaltransparencia.protocportal.domain.EstatisticaEsicGenero;
import br.com.elotech.portaltransparencia.protocportal.domain.EstatisticaEsicIdade;
import br.com.elotech.portaltransparencia.protocportal.domain.EstatisticaEsicMensal;
import br.com.elotech.portaltransparencia.protocportal.service.EstatisticaEsicManualService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/estatisticas-esic-manual"})
public class EstatisticaEsicManualResource {
    private final EstatisticaEsicManualService service;

    @GetMapping(value={"/mensal"})
    public ResponseEntity<List<EstatisticaEsicMensal>> findMensalByEntidadeAndExercicio(@RequestParam Long entidade, @RequestParam Long exercicio) {
        return ResponseEntity.ok((Object)this.service.findMensalByEntidadeAndExercicio(entidade, exercicio));
    }

    @PostMapping(value={"/mensal"})
    public ResponseEntity<List<EstatisticaEsicMensal>> saveMensal(@RequestBody List<EstatisticaEsicMensal> estatisticas) {
        List saved = this.service.saveMensal(estatisticas);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/mensal/{id}"})
    public ResponseEntity<EstatisticaEsicMensal> updateMensal(@PathVariable Long id, @RequestBody EstatisticaEsicMensal estatistica) {
        estatistica.setId(id);
        return ResponseEntity.ok((Object)this.service.updateMensal(estatistica));
    }

    @GetMapping(value={"/genero"})
    public ResponseEntity<List<EstatisticaEsicGenero>> findGeneroByEntidadeAndExercicio(@RequestParam Long entidade, @RequestParam Long exercicio) {
        return ResponseEntity.ok((Object)this.service.findGeneroByEntidadeAndExercicio(entidade, exercicio));
    }

    @PostMapping(value={"/genero"})
    public ResponseEntity<List<EstatisticaEsicGenero>> saveGenero(@RequestBody List<EstatisticaEsicGenero> estatisticas) {
        List saved = this.service.saveGenero(estatisticas);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/genero/{id}"})
    public ResponseEntity<EstatisticaEsicGenero> updateGenero(@PathVariable Long id, @RequestBody EstatisticaEsicGenero estatistica) {
        estatistica.setId(id);
        return ResponseEntity.ok((Object)this.service.updateGenero(estatistica));
    }

    @GetMapping(value={"/idade"})
    public ResponseEntity<List<EstatisticaEsicIdade>> findIdadeByEntidadeAndExercicio(@RequestParam Long entidade, @RequestParam Long exercicio) {
        return ResponseEntity.ok((Object)this.service.findIdadeByEntidadeAndExercicio(entidade, exercicio));
    }

    @PostMapping(value={"/idade"})
    public ResponseEntity<List<EstatisticaEsicIdade>> saveIdade(@RequestBody List<EstatisticaEsicIdade> estatisticas) {
        List saved = this.service.saveIdade(estatisticas);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/idade/{id}"})
    public ResponseEntity<EstatisticaEsicIdade> updateIdade(@PathVariable Long id, @RequestBody EstatisticaEsicIdade estatistica) {
        estatistica.setId(id);
        return ResponseEntity.ok((Object)this.service.updateIdade(estatistica));
    }

    @GetMapping(value={"/escolaridade"})
    public ResponseEntity<List<EstatisticaEsicEscolaridade>> findEscolaridadeByEntidadeAndExercicio(@RequestParam Long entidade, @RequestParam Long exercicio) {
        return ResponseEntity.ok((Object)this.service.findEscolaridadeByEntidadeAndExercicio(entidade, exercicio));
    }

    @PostMapping(value={"/escolaridade"})
    public ResponseEntity<List<EstatisticaEsicEscolaridade>> saveEscolaridade(@RequestBody List<EstatisticaEsicEscolaridade> estatisticas) {
        List saved = this.service.saveEscolaridade(estatisticas);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/escolaridade/{id}"})
    public ResponseEntity<EstatisticaEsicEscolaridade> updateEscolaridade(@PathVariable Long id, @RequestBody EstatisticaEsicEscolaridade estatistica) {
        estatistica.setId(id);
        return ResponseEntity.ok((Object)this.service.updateEscolaridade(estatistica));
    }

    @Generated
    public EstatisticaEsicManualResource(EstatisticaEsicManualService service) {
        this.service = service;
    }
}

