/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CedidoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.CedidoDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindCedidoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CedidoService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class CedidoServiceOxy
implements CedidoService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final EntidadeFeignClient entidadeFeignClient;
    private final BaseExport baseExport;

    public Page<CedidoDTO> findCedidos(FindCedidoParams params, Pageable pageable) {
        EloPage cedidos = this.integracaoFolhaPortalTransparenciaClient.findCedidos(FindCedidoParams.toFiltroCedido((FindCedidoParams)params), pageable);
        List cedidosDTO = cedidos.getContent().stream().map(CedidoDTOConverter::toCedidoDTO).collect(Collectors.toList());
        return new PageImpl(cedidosDTO, pageable, cedidos.getTotalElements());
    }

    public String findNomeEntidadeById(Long entidadeId) {
        EntidadeDTO entidadeDTO = this.entidadeFeignClient.findOne(entidadeId);
        return Objects.nonNull(entidadeDTO) ? entidadeDTO.getNome() : "";
    }

    @Generated
    public CedidoServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, EntidadeFeignClient entidadeFeignClient, BaseExport baseExport) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.entidadeFeignClient = entidadeFeignClient;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

