/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.CargoReduzidoDTO;
import br.com.elotech.folhapagamento.client.domain.MatrizSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoQuadroSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoQuadroSalarialViewDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoViewDTO;
import br.com.elotech.folhapagamento.client.domain.QuadroSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.enums.CargoTipo;
import br.com.elotech.portaltransparencia.aiseportal.domain.Cargo;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacional;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacionalNivel;
import br.com.elotech.portaltransparencia.aiseportal.domain.QuadroSalarial;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CargoFaixaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.CargoParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CargoService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class CargoServiceOxy
implements CargoService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;

    public List<Cargo> findCargo(CargoParams params) {
        return new ArrayList<Cargo>();
    }

    public List<QuadroSalarial> findQuadroSalarial(CargoParams params) {
        return new ArrayList<QuadroSalarial>();
    }

    public List<GrupoOcupacional> findGrupoOcupacional(CargoParams params) {
        return new ArrayList<GrupoOcupacional>();
    }

    public List<GrupoOcupacionalNivel> findGrupoOcupacionalNivel(CargoParams params) {
        return new ArrayList<GrupoOcupacionalNivel>();
    }

    public Page<CargoFaixaDTO> findCargos(CargoParams params, Pageable pageable) {
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public List<CargoFaixaDTO> findFaixas(CargoParams params) {
        return new ArrayList<CargoFaixaDTO>();
    }

    public Page<PortalTransparenciaCargoDTO> findCargosOxy(CargoParams params, Pageable pageable) {
        EloPage cargos;
        if (this.getUtilizaNovaMatriz(params.getEntidade()).booleanValue()) {
            EloPage cargoQuadroSalarialDTO = this.integracaoFolhaPortalTransparenciaClient.findCargosQuadroSalarial(CargoParamsConverter.toFiltroDTO((CargoParams)params), pageable);
            cargos = new EloPage(cargoQuadroSalarialDTO.getContent().stream().map(item -> {
                PortalTransparenciaCargoDTO dto = new PortalTransparenciaCargoDTO();
                dto.setId(item.getId());
                dto.setEntidade(item.getEntidade());
                dto.setDescricao(item.getDescricao());
                dto.setCargoTipo(item.getCargoTipo());
                dto.setQuantidadeVagas(item.getQuantidadeVagas());
                dto.setQuantidadeVagasOcupadas(item.getQuantidadeVagasOcupadas());
                dto.setQuantidadeVagasDisponiveis(item.getQuantidadeVagasDisponiveis());
                dto.setMatrizSalarialNome(item.getQuadroSalarialPath());
                dto.setPlanoSalarialDescricao(item.getQuadroSalarialDescricao());
                return dto;
            }).collect(Collectors.toList()));
        } else {
            cargos = this.integracaoFolhaPortalTransparenciaClient.findAllCargos(CargoParamsConverter.toFiltroDTO((CargoParams)params), pageable);
        }
        return new PageImpl(cargos.getContent(), pageable, cargos.getTotalElements());
    }

    public List<PortalTransparenciaCargoViewDTO> getMatrizVigente(CargoParams params) {
        return this.integracaoFolhaPortalTransparenciaClient.getCargoMatrizVigente(CargoParamsConverter.toFiltroDTO((CargoParams)params));
    }

    public List<CargoTipo> getTipoCargo(String descricao) {
        return Stream.of(CargoTipo.values()).filter(cargoTipo -> StringUtils.retiraAcentos((String)cargoTipo.getDescricao()).toLowerCase().contains(StringUtils.retiraAcentos((String)descricao).toLowerCase())).collect(Collectors.toList());
    }

    public List<String> getVigenciasMatrizSalarial(Long matrizId) {
        return this.integracaoFolhaPortalTransparenciaClient.getAllVigenciasMatriz(matrizId);
    }

    public List<CargoReduzidoDTO> getCargosReduzido(Long entidadeId, String descricao) {
        return this.integracaoFolhaPortalTransparenciaClient.getCargosReduzido(entidadeId, descricao);
    }

    public List<MatrizSalarialDTO> findAllMatrizSalarial(Long entidadeId, String nomeMatrizSalarial) {
        return this.integracaoFolhaPortalTransparenciaClient.findAllMatrizSalarial(entidadeId, nomeMatrizSalarial);
    }

    public List<QuadroSalarialDTO> findAllQuadroSalarial(Long entidadeId, String nomeQuadroSalarial) {
        return this.integracaoFolhaPortalTransparenciaClient.findAllQuadroSalarial(entidadeId, nomeQuadroSalarial);
    }

    public Boolean getUtilizaNovaMatriz(Long entidadeId) {
        return this.integracaoFolhaPortalTransparenciaClient.getUtilizaNovaMatriz(entidadeId);
    }

    public Page<PortalTransparenciaCargoQuadroSalarialDTO> findCargosQuadroSalarialOxy(CargoParams params, Pageable pageable) {
        EloPage cargos = this.integracaoFolhaPortalTransparenciaClient.findCargosQuadroSalarial(CargoParamsConverter.toFiltroDTO((CargoParams)params), pageable);
        return new PageImpl(cargos.getContent(), pageable, cargos.getTotalElements());
    }

    public PortalTransparenciaCargoQuadroSalarialViewDTO getCargoDetalhes(CargoParams params) {
        return this.integracaoFolhaPortalTransparenciaClient.getCargoDetalhes(CargoParamsConverter.toFiltroDTO((CargoParams)params));
    }

    @Generated
    public CargoServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
    }
}

