/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.service.AutonomoService;
import br.com.elotech.portaltransparencia.folhaportal.service.VencimentoDescontoServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class AutonomoServiceOxy
implements AutonomoService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy;
    private final EntidadeFeignClient entidadeClient;
    private final BaseExport baseExport;
    private static final String headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Atividade,Lota\u00e7\u00e3o,In\u00edcio Contrato, Fim Contrato";
    private static final String fields = "nome,matricula,situacao,descricaoAtividades,descricaoLotacao,dataAdmissao,dataFimContrato";

    public Page<ServidorDTO> loadAutonomos(ServidorParams params, Pageable pageable) {
        EloPage autonomos = this.integracaoFolhaPortalTransparenciaClient.getAutonomos(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(autonomos.getContent().stream().map(ServidorDTOConverter::portalTransparenciaServidoresDTOToServidorDTO).collect(Collectors.toList()), pageable, autonomos.getTotalElements());
    }

    public Optional<ServidorDTO> loadAutonomo(ServidorParams params) {
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        PortalTransparenciaDadosServidorDTO dadosAutonomo = this.integracaoFolhaPortalTransparenciaClient.getDadosAutonomo(entidade, params.getExercicio(), params.getMatricula());
        if (Objects.nonNull(dadosAutonomo)) {
            return Optional.of(ServidorDTOConverter.portalTransparenciaDadosServidorDTOToServidorDTO((PortalTransparenciaDadosServidorDTO)dadosAutonomo));
        }
        return Optional.empty();
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        return this.vencimentoDescontoServiceOxy.getLoadVencimentoEDescontos(params);
    }

    public String findNomeEntidadeById(Long entidadeId) {
        EntidadeDTO entidadeDTO = this.entidadeClient.findOne(entidadeId);
        return Objects.nonNull(entidadeDTO) ? entidadeDTO.getNome() : "";
    }

    public String headerFields() {
        return headerFields;
    }

    public String fields() {
        return fields;
    }

    public float[] fieldsPerc() {
        return new float[]{1.5f, 0.9f, 1.0f, 1.5f, 1.5f, 0.9f, 0.9f};
    }

    public int[] fieldTab() {
        return new int[]{100, 20, 20, 100, 100, 50, 50};
    }

    @Generated
    public AutonomoServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy, EntidadeFeignClient entidadeClient, BaseExport baseExport) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.vencimentoDescontoServiceOxy = vencimentoDescontoServiceOxy;
        this.entidadeClient = entidadeClient;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

