/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.common.dto.RegistroDTO;
import br.com.elotech.core.common.license.rest.License;
import br.com.elotech.core.common.license.rest.LicenseClientRest;
import br.com.elotech.core.crypto.EloCrypto;
import br.com.elotech.portaltransparencia.contabportal.domain.Registro;
import br.com.elotech.portaltransparencia.contabportal.domain.RegistroPK;
import br.com.elotech.portaltransparencia.contabportal.repository.RegistroRepository;
import br.com.elotech.portaltransparencia.contabportal.service.RegistroService;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class RegistroServiceImpl
implements RegistroService {
    private static final Logger LOG = LoggerFactory.getLogger(RegistroServiceImpl.class);
    private final RegistroRepository registroRepository;
    private final String urlBlueMix;
    private final LicenseClientRest licenseClientRest;

    @Autowired
    public RegistroServiceImpl(RegistroRepository registroRepository, LicenseClientRest licenseClientRest, @Value(value="${elotech.licenca.url:}") String urlBlueMix) {
        this.registroRepository = registroRepository;
        this.licenseClientRest = licenseClientRest;
        this.urlBlueMix = urlBlueMix;
    }

    public Boolean isValid(String modulo, String nome) {
        Registro registro = null;
        registro = this.registroRepository.loadLastRegistro(modulo, nome);
        if (Objects.nonNull(registro) && this.isValid(registro.toRegistroDTO()).booleanValue()) {
            return Boolean.TRUE;
        }
        LOG.info("Registro local inv\u00e1lido. Verificando no servi\u00e7o de licen\u00e7as!");
        if (this.hasBlueMixProperty().booleanValue()) {
            registro = this.isValidBlueMixLicense(modulo, nome);
            LOG.info("Licen\u00e7a encontrada, verificando validade: {}", (Object)registro);
            return this.isValid(registro.toRegistroDTO());
        }
        LOG.warn("Servi\u00e7o de licen\u00e7as n\u00e3o configurado!");
        return Boolean.FALSE;
    }

    private Boolean hasBlueMixProperty() {
        return StringUtils.isNotBlank((String)this.urlBlueMix);
    }

    private Registro isValidBlueMixLicense(String modulo, String nome) {
        Optional license = this.licenseClientRest.getLicense(modulo, nome);
        Registro registro = new Registro();
        RegistroPK pk = new RegistroPK();
        pk.setModulo(modulo);
        pk.setNome(nome);
        registro.setId(pk);
        if (license.isPresent()) {
            pk.setValidade(((License)license.get()).getDate());
            registro.setCodigo(((License)license.get()).getCode());
            registro.setSenha(((License)license.get()).getPassword());
            registro.setDataLiberacao(LocalDate.now());
            String hash = EloCrypto.cifra((String)registro.getCalculatedHash());
            registro.setHash(hash);
            return (Registro)this.registroRepository.save((Object)registro);
        }
        return registro;
    }

    private Boolean isValid(RegistroDTO registro) {
        if (Objects.isNull(registro)) {
            return false;
        }
        if (!registro.isValid()) {
            return false;
        }
        if (registro.getValidade().compareTo(LocalDate.now()) < 0) {
            return false;
        }
        return true;
    }
}

