/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AditivoConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ConvenioRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindConvenioParams;
import br.com.elotech.portaltransparencia.contabportal.service.ConvenioService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class ConvenioSustentacaoServiceImpl
implements ConvenioService {
    private final ConvenioRepository convenioRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public ConvenioSustentacaoServiceImpl(ConvenioRepository convenioRepository, ArquivoService arquivoService) {
        this.convenioRepository = convenioRepository;
        this.arquivoService = arquivoService;
    }

    public Page<ConvenioDTO> findConvenios(FindConvenioParams params, Pageable pageable) {
        return this.convenioRepository.findConvenios(params, pageable);
    }

    public Optional<ConvenioDTO> findConvenio(FindConvenioParams params) {
        return this.convenioRepository.findConvenio(params);
    }

    public List<ArquivoPessoalDTO> findArquivos(FindConvenioParams params) {
        return this.convenioRepository.findArquivos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public ArquivoDTO findArquivoDownload(Long id) {
        return null;
    }

    public List<AditivoConvenioDTO> findAditivos(FindConvenioParams params) {
        return this.convenioRepository.findAditivos(params);
    }

    public List<RepasseConvenioDTO> findRepassesConvenio(FindConvenioParams params) {
        return this.convenioRepository.findRepassesConvenio(params);
    }

    public List<RepasseConvenioDTO> findContraPartida(FindConvenioParams params) {
        return this.convenioRepository.findContraPartida(params);
    }

    public List<RepasseConvenioDTO> findPagamentosConvenio(FindConvenioParams params) {
        return this.convenioRepository.findPagamentosConvenio(params);
    }
}

