/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.contabilidade.client.DotacaoFeignClient;
import br.com.elotech.orcamento.client.PPAFeignClient;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPADTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPAProgramaDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.AvaliacaoPpaToTree;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AvaliacaoPPAParams;
import br.com.elotech.portaltransparencia.contabportal.service.AvaliacaoPPAService;
import br.com.elotech.portaltransparencia.dto.DotacaoSaldoLoadedDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class AvaliacaoPPAServiceOxyCloudImpl
implements AvaliacaoPPAService {
    private static final Long THREE_YEARS = 3L;
    private final DotacaoFeignClient dotacaoFeignClient;
    private final PPAFeignClient ppaFeignClient;

    public AvaliacaoPPADTO findAvaliacoesPPA(AvaliacaoPPAParams params) {
        ArrayList avaliacoesRealizadas = new ArrayList();
        this.dotacaoFeignClient.findAllDotacaoSaldoLoaded(params.getEntidade(), params.getExercicio()).stream().collect(Collectors.groupingBy(AvaliacaoPPAServiceOxyCloudImpl::groupDotacaoSaldoLoaded)).values().stream().forEach(saldos -> avaliacoesRealizadas.add(AvaliacaoPPAProgramaDTO.fromDotacaoSaldo((List)saldos)));
        List avaliacoesFiltered = this.filterByProjetoDescricao(avaliacoesRealizadas, params);
        List avaliacoesOrc = this.ppaFeignClient.findAllByExercicioRetroativos(params.getExercicio(), THREE_YEARS);
        avaliacoesFiltered.forEach(avaliacao -> avaliacoesOrc.stream().filter(avaOrc -> Objects.equals(avaOrc.getCodigoAcao(), avaliacao.getProjeto()) && Objects.equals(avaOrc.getCodigoFuncao(), avaliacao.getFuncao()) && Objects.equals(avaOrc.getCodigoSubfuncao(), avaliacao.getSubfuncao()) && Objects.equals(avaOrc.getCodigoPrograma(), avaliacao.getPrograma()) && Objects.equals(avaOrc.getUnidadeComposta(), avaliacao.getUnidade()) && Objects.equals(avaOrc.getExercicio(), avaliacao.getExercicio())).findFirst().ifPresent(arg_0 -> ((AvaliacaoPPAProgramaDTO)avaliacao).setMetaPrevistaAndRealizada(arg_0)));
        return new AvaliacaoPpaToTree().apply(avaliacoesFiltered);
    }

    private List<AvaliacaoPPAProgramaDTO> filterByProjetoDescricao(List<AvaliacaoPPAProgramaDTO> avaliacoesRealizadas, AvaliacaoPPAParams params) {
        if (params.getDescricaoProjeto().isPresent()) {
            return avaliacoesRealizadas.stream().filter(a -> a.getDescricaoProjeto().contains((CharSequence)params.getDescricaoProjeto().get())).collect(Collectors.toList());
        }
        return avaliacoesRealizadas;
    }

    private static String groupDotacaoSaldoLoaded(DotacaoSaldoLoadedDTO dto) {
        StringBuilder sb = new StringBuilder();
        sb.append(dto.getDotacao().getProjetoAtividade().getCodigo());
        sb.append(dto.getDotacao().getFuncao().getCodigo());
        sb.append(dto.getDotacao().getSubfuncao().getCodigo());
        sb.append(dto.getDotacao().getPrograma().getCodigo());
        sb.append(dto.getDotacao().getUnidade().getUnidadeComposta());
        sb.append(dto.getDotacao().getExercicio());
        return sb.toString();
    }

    @Generated
    public AvaliacaoPPAServiceOxyCloudImpl(DotacaoFeignClient dotacaoFeignClient, PPAFeignClient ppaFeignClient) {
        this.dotacaoFeignClient = dotacaoFeignClient;
        this.ppaFeignClient = ppaFeignClient;
    }
}

