/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.service.PortalAdminOxyArquivoService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoContent;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.repository.ArquivoRepository;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArquivoContabilServiceImpl
implements ArquivoContabilService {
    private final PortalAdminOxyArquivoService arquivoService;
    private final ArquivoRepository arquivoRepository;
    private final ArquivoService eloArquivoService;
    private final Boolean isIntegradoOxy;

    @Autowired
    public ArquivoContabilServiceImpl(PortalAdminOxyArquivoService arquivoService, ArquivoRepository arquivoRepository, ArquivoService eloArquivoService, @Value(value="${elotech.integradooxy:false}") Boolean isIntegradoOxy) {
        this.arquivoService = arquivoService;
        this.arquivoRepository = arquivoRepository;
        this.eloArquivoService = eloArquivoService;
        this.isIntegradoOxy = isIntegradoOxy;
    }

    public ArquivoContab save(ArquivoContab arquivo) {
        return (ArquivoContab)this.arquivoRepository.save((Object)arquivo);
    }

    public ArquivoContab findOne(Long id) {
        return (ArquivoContab)this.arquivoRepository.findOne((Object)id);
    }

    public void remove(Long id) {
        ArquivoContab arquivoContab = (ArquivoContab)this.arquivoRepository.findOne((Object)id);
        Optional.ofNullable(arquivoContab).ifPresent(arg_0 -> ((PortalAdminOxyArquivoService)this.arquivoService).deletarArquivo(arg_0));
    }

    public ArquivoContab salvarArquivo(MultipartFile file, String nome) throws IOException {
        if (this.isIntegradoOxy.booleanValue()) {
            return this.arquivoService.adicionarArquivo(file);
        }
        ArquivoContent eloArquivoContent = new ArquivoContent();
        eloArquivoContent.setBinary(file.getBytes());
        Arquivo eloArquivo = new Arquivo();
        eloArquivo.setContent(eloArquivoContent);
        eloArquivo.setNome(nome);
        eloArquivo.setDataCriacao(LocalDate.now());
        eloArquivoContent.withArquivo(eloArquivo);
        Arquivo eloArquivoSaved = this.eloArquivoService.save(eloArquivo);
        ArquivoContab arquivoContab = new ArquivoContab();
        arquivoContab.setEloArquivo(eloArquivoSaved);
        arquivoContab.setNome(eloArquivoSaved.getNome());
        arquivoContab.setData(LocalDateTime.now());
        arquivoContab.setDataArquivo(LocalDateTime.now());
        return arquivoContab;
    }

    public ArquivoContab atualizarArquivo(Long idArquivoContab, MultipartFile atualizarArquivo) {
        return this.arquivoService.atualizarArquivo(idArquivoContab, atualizarArquivo);
    }
}

