/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AdiantamentoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DocumentoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.AdiantamentoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.AdiantamentoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class AdiantamentoSustentacaoServiceImpl
implements AdiantamentoService {
    private final AdiantamentoRepository adiantamentoRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public AdiantamentoSustentacaoServiceImpl(AdiantamentoRepository adiantamentoRepository, ArquivoService arquivoService) {
        this.adiantamentoRepository = adiantamentoRepository;
        this.arquivoService = arquivoService;
    }

    public Page<AdiantamentoPessoalDTO> findAdiantamentos(FindPessoalParams params, Pageable pageable) {
        return this.adiantamentoRepository.findAdiantamentos(params, pageable);
    }

    public AdiantamentoPessoalDTO findTotalAdiantamentos(FindPessoalParams params) {
        return this.adiantamentoRepository.findTotalAdiantamentos(params);
    }

    public Optional<AdiantamentoPessoalDTO> findAdiantamento(FindPessoalParams params) {
        return this.adiantamentoRepository.findAdiantamento(params);
    }

    public Optional<AdiantamentoPessoalDTO> findPrestacaoContas(FindPessoalParams params) {
        return this.adiantamentoRepository.findPrestacaoContas(params);
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams params) {
        return this.adiantamentoRepository.findArquivos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<DocumentoPessoalDTO> findDocumentos(FindPessoalParams params) {
        return this.adiantamentoRepository.findDocumentos(params);
    }
}

