/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FornecedorParams;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorOxyService;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorService;
import br.com.elotech.unico.client.PessoaFeignClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.jdbc.core.RowMapper;

public class FornecedorOxyService
implements FornecedorService {
    private final PessoaFeignClient pessoaFeignClient;
    private final DatasourceWrapper datasourceWrapper;
    private static final String SQL_DEFAULT = "SELECT p.id as id, p.cnpj_cpf as CNPJ, p.nome, rf.nomeantigo as nomeAntigo, rf.iniciovigencia as inicioVigenciaNome, c.email, coalesce(c.telefonecelular, c.telefonecomercial), '',  p.tipopessoa  FROM unico.pessoa p  LEFT JOIN unico.pessoaalterarazao rf on rf.pessoa = p.id  LEFT JOIN  unico.contatopessoa c on c.pessoa = p.id ";

    public Page<Fornecedor> getFornecedores(Pageable pageable, FornecedorParams fornecedorParams) {
        return new PageImpl(((List)Optional.ofNullable(this.pessoaFeignClient.findPessoaByRSQL("", Optional.ofNullable(fornecedorParams).orElse(new FornecedorParams()).toFiltroOxy())).map(HttpEntity::getBody).map(EloPage::getContent).orElse(new ArrayList())).stream().map(Fornecedor::fromPessoaDTO).collect(Collectors.toList()));
    }

    public Fornecedor getFornecedor(Long id) {
        return Optional.ofNullable(this.pessoaFeignClient.findPessoaById("", id)).map(Fornecedor::fromPessoaDTO).orElseThrow(() -> new IllegalArgumentException("Pessoa n\u00e3o encontrada!"));
    }

    public Fornecedor findById(Long id) {
        return this.datasourceWrapper.getJdbcTemplate().query("SELECT p.id as id, p.cnpj_cpf as CNPJ, p.nome, rf.nomeantigo as nomeAntigo, rf.iniciovigencia as inicioVigenciaNome, c.email, coalesce(c.telefonecelular, c.telefonecomercial), '',  p.tipopessoa  FROM unico.pessoa p  LEFT JOIN unico.pessoaalterarazao rf on rf.pessoa = p.id  LEFT JOIN  unico.contatopessoa c on c.pessoa = p.id  WHERE p.id = " + id.toString() + "  order by p.id ", (RowMapper)new EntidadeRowMapper(Fornecedor.class)).stream().findFirst().orElse(null);
    }

    public List<Fornecedor> findAllById(Set<Long> id) {
        String sql = "SELECT p.id as id, p.cnpj_cpf as CNPJ, p.nome, rf.nomeantigo as nomeAntigo, rf.iniciovigencia as inicioVigenciaNome, c.email, coalesce(c.telefonecelular, c.telefonecomercial), '',  p.tipopessoa  FROM unico.pessoa p  LEFT JOIN unico.pessoaalterarazao rf on rf.pessoa = p.id  LEFT JOIN  unico.contatopessoa c on c.pessoa = p.id  WHERE p.id IN (" + id.stream().map(Object::toString).collect(Collectors.joining(",")) + ")  order by p.id ";
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new EntidadeRowMapper(Fornecedor.class));
    }

    @Generated
    public FornecedorOxyService(PessoaFeignClient pessoaFeignClient, DatasourceWrapper datasourceWrapper) {
        this.pessoaFeignClient = pessoaFeignClient;
        this.datasourceWrapper = datasourceWrapper;
    }
}

