/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.console.dto.RolesUsuarioDTO;
import br.com.elotech.console.dto.UsuarioEntidadeDTO;
import br.com.elotech.portaltransparencia.admportal.utils.SecurityService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.EntidadeServiceUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntidadeContabilidadeOxyService
implements EntidadeContabilidadeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntidadeContabilidadeOxyService.class);
    private final EntidadeServiceUtils entidadeUtils;
    private final EntidadeRepository entidadeRepository;
    private final UsuarioClient usuarioClient;
    private final SecurityService securityService;

    public EntidadeContabilidadeOxyService(EntidadeServiceUtils entidadeUtils, EntidadeRepository entidadeRepository, UsuarioClient usuarioClient, SecurityService securityService) {
        this.entidadeUtils = entidadeUtils;
        this.entidadeRepository = entidadeRepository;
        this.usuarioClient = usuarioClient;
        this.securityService = securityService;
    }

    public Optional<Entidade> getEntidadePrincipal() {
        List entidades = this.getEntidadesPermitidosAcesso(Boolean.FALSE);
        return entidades.stream().peek(entidade -> log.debug("Entidade {}", entidade)).filter(Entidade::getPrincipal).findFirst().or(() -> entidades.stream().min(Comparator.comparing(Entidade::getId)));
    }

    public String resolveWhereSQL(Long entidade) {
        return this.entidadeUtils.resolveWhereSQL(entidade);
    }

    public Entidade getEntidadeSelecionada(Long idEntidade) {
        return this.findOne(idEntidade);
    }

    public Boolean verificaRegistro(Entidade entidade) {
        return true;
    }

    public List<Entidade> getEntidades() {
        return this.findAll();
    }

    public List<Entidade> getEntidadesPermitidosAcesso(Boolean somenteHabilitados) {
        List idsNaoHabilitados = this.entidadeUtils.idsEntidadesNaoHabilitadasPortal();
        if (this.usuarioClient == null || this.securityService.getUserId() == null) {
            List entidades = this.entidadeRepository.findAll();
            return entidades.stream().filter(entidade -> !idsNaoHabilitados.contains(entidade.getId())).collect(Collectors.toList());
        }
        UUID userId = this.securityService.getUserId();
        List entidadesUsuario = this.usuarioClient.findAllEntidadesByUsuario(userId.toString());
        Set entidadesComPermissao = entidadesUsuario.stream().filter(entidadeUsuario -> {
            UUID entidadeId = entidadeUsuario.getEntidadeId();
            try {
                RolesUsuarioDTO rolesDto = this.usuarioClient.findAllRolesByUsuarioAndEntidadeAndModulo(userId, entidadeId, Modulo.OXY_PORTAL_TRANSPARENCIA);
                return rolesDto.getClientRoles().stream().anyMatch(role -> role.getName().equalsIgnoreCase("administrador"));
            }
            catch (IllegalArgumentException e) {
                log.warn("M\u00f3dulo OXY Portal Transpar\u00eancia sem permiss\u00e3o para entidade {}", (Object)entidadeId);
                return false;
            }
        }).map(UsuarioEntidadeDTO::getEntidadeId).collect(Collectors.toSet());
        if (entidadesComPermissao.isEmpty()) {
            log.debug("Usu\u00e1rio {} n\u00e3o possui entidades associadas", (Object)userId);
            return Collections.emptyList();
        }
        List entidadesPermitidos = this.entidadeRepository.findAllByEntidadeConsole(entidadesComPermissao);
        return somenteHabilitados != false ? entidadesPermitidos.stream().filter(entidade -> !idsNaoHabilitados.contains(entidade.getId())).collect(Collectors.toList()) : entidadesPermitidos;
    }

    public List<Entidade> findByNome(String nome) {
        return this.getEntidadesPermitidosAcesso(Boolean.valueOf(true));
    }

    public Entidade findOne(Long id) {
        return this.entidadeRepository.findOne(id);
    }

    public Integer getTamanhoReceita(Long entidade, Long exercicio) {
        return null;
    }

    public String getUf(Long entidade) {
        return null;
    }

    public String getNomeFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        return "";
    }

    public String getCNPJFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        return "";
    }

    public String isHabilitadoAssinaturaPersonalizadaFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        return "";
    }

    public boolean isHabilitadoPortal(Long entidade) {
        return this.entidadeUtils.isHabilitadoPortal(entidade);
    }

    public List<Entidade> findAll() {
        List idsNaoHabilitados = this.entidadeUtils.idsEntidadesNaoHabilitadasPortal();
        List entidades = this.entidadeRepository.findAll();
        return entidades.stream().filter(entidade -> !idsNaoHabilitados.contains(entidade.getId())).collect(Collectors.toList());
    }

    public Optional<Entidade> getEntidadePrincipalToLog() {
        return Optional.empty();
    }
}

