/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.DiariaFeignClient;
import br.com.elotech.contabilidade.client.dto.DiariaMovimentacaoEmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.DiariaMovimentacaoValorDTO;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DiariaPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.TipoObjetivoDiariaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.TipoSecretariaDiariaDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.DiariaService;
import br.com.elotech.portaltransparencia.contabportal.utils.DiariaOxyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class DiariaOxyService
implements DiariaService {
    private final DiariaFeignClient diariaFeignClient;
    private static final String DIARIA = "1";

    public Page<DiariaPessoalDTO> findDiarias(FindPessoalParams findPessoalParams, Pageable pageable) {
        EloPage diarias = this.diariaFeignClient.findDiariasWithHeaders(DiariaOxyUtils.buildSearch((FindPessoalParams)findPessoalParams, (String)";", (String)DIARIA), DiariaOxyUtils.buildSort((Pageable)pageable), findPessoalParams.getEntidade(), findPessoalParams.getExercicio());
        ArrayList diariaPessoal = new ArrayList();
        diarias.getContent().forEach(diaria -> diariaPessoal.add(new DiariaPessoalDTO(diaria)));
        return new PageImpl(diariaPessoal, pageable, diarias.getTotalElements());
    }

    public DiariaPessoalDTO findTotalDiarias(FindPessoalParams findPessoalParams) {
        DiariaMovimentacaoValorDTO diariaValor = this.diariaFeignClient.findTotalDiarias(DiariaOxyUtils.buildSearch((FindPessoalParams)findPessoalParams, (String)";", (String)DIARIA));
        DiariaPessoalDTO diaria = new DiariaPessoalDTO();
        diaria.setValorEmpenho(diariaValor.getValorEmpenho());
        diaria.setValorDiarias(diariaValor.getValorTotal());
        diaria.setValorAnulado(diariaValor.getValorAnulado());
        return diaria;
    }

    public Optional<DiariaPessoalDTO> findDiaria(FindPessoalParams findPessoalParams) {
        DiariaMovimentacaoEmpenhoDTO diaria = this.diariaFeignClient.findDetalhesDiaria(findPessoalParams.getEmpenho(), findPessoalParams.getExercicio(), findPessoalParams.getEntidade());
        DiariaPessoalDTO diariaPessoal = new DiariaPessoalDTO(diaria);
        return Optional.of(diariaPessoal);
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams findPessoalParams) {
        ArrayList<ArquivoPessoalDTO> anexos = new ArrayList<ArquivoPessoalDTO>();
        this.diariaFeignClient.findDetalhesDiaria(findPessoalParams.getEmpenho(), findPessoalParams.getExercicio(), findPessoalParams.getEntidade()).getAnexos().forEach(diaria -> anexos.add(new ArquivoPessoalDTO(diaria)));
        return anexos;
    }

    public List<TipoObjetivoDiariaDTO> getTiposObjetivoDiaria() {
        List objetivosDiaria = this.diariaFeignClient.findObjetivosDiaria();
        ArrayList<TipoObjetivoDiariaDTO> tipoObjetivoDiaria = new ArrayList<TipoObjetivoDiariaDTO>();
        objetivosDiaria.forEach(objetivo -> tipoObjetivoDiaria.add(new TipoObjetivoDiariaDTO(objetivo)));
        return tipoObjetivoDiaria;
    }

    public List<TipoSecretariaDiariaDTO> getTiposSecretariaDiaria(FindPessoalParams params) {
        return new ArrayList<TipoSecretariaDiariaDTO>();
    }

    public List<DiariaPessoalDTO> findDiariasWithoutQuantidade(FindPessoalParams params) {
        return new ArrayList<DiariaPessoalDTO>();
    }

    @Generated
    public DiariaOxyService(DiariaFeignClient diariaFeignClient) {
        this.diariaFeignClient = diariaFeignClient;
    }
}

