/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.FornecedorAPagarDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorAPagarService;
import br.com.elotech.portaltransparencia.web.rest.params.FornecedorAPagarParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/fornecedorapagar"})
public class FornecedorAPagarResource {
    private final FornecedorAPagarService fornecedorAPagarService;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final ElotechProperties elotechProperties;

    @Autowired
    public FornecedorAPagarResource(FornecedorAPagarService fornecedorAPagarService, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository, ElotechProperties elotechProperties) {
        this.fornecedorAPagarService = fornecedorAPagarService;
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
        this.elotechProperties = elotechProperties;
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<Page<FornecedorAPagarDTO>> getFornecedoresAPagar(Pageable pageable, FornecedorAPagarParams params) {
        return ResponseEntity.ok((Object)this.fornecedorAPagarService.getFornecedoresAPagar(pageable, params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView getFornecedoresAPagarExport(Pageable pageable, HttpServletRequest request, HttpServletResponse response, FornecedorAPagarParams params) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.fornecedorAPagarService.getFornecedoresAPagar((Pageable)pageRequest, params);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Fornecedores a Pagar");
        reportParam.setClazzDTO(FornecedorAPagarDTO.class);
        reportParam.setHeaderFields("Nome,CNPJ/CPF,Empenhado,Anulado,Liquidado,Retido,Pago,A Pagar");
        reportParam.setFields("nome,cnpjCpf,empenhado,anulado,liquidado,retido,pago,aPagar");
        float[] fieldsPerc = new float[]{2.1f, 1.3f, 1.2f, 1.0f, 1.1f, 1.1f, 1.1f, 1.1f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{100, 20, 20, 20, 20, 20, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setSumFields("empenhado,anulado,liquidado,retido,pago,aPagar");
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/totais"})
    public FornecedorAPagarDTO getFornecedoresAPagarTotais(FornecedorAPagarParams params) {
        return this.fornecedorAPagarService.getFornecedoresAPagarTotais(params);
    }
}

