/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AdiantamentoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoAditivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoArquivoSitDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoRemuneracaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoSituacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoSituacaoDetalheDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.AdiantamentoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.SubvencaoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AditivoParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PrestacaoContasParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.SubvencaoParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class SubvencaoRepositoryImpl
implements SubvencaoRepository {
    private static final String SUBVENCOES = "db/sql/contab/subvencoes.sql";
    private static final String SUBVENCAO_VALORES = "db/sql/contab/subvencao-valores-liberados.sql";
    private static final String SUBVENCAO_PRESTACAO_CONTAS = "db/sql/contab/subvencao-prestacao-contas.sql";
    private static final String SUBVENCAO_ADITIVOS = "db/sql/contab/subvencao-aditivos.sql";
    private static final String SUBVENCAO_REMUNERACOES = "db/sql/contab/subvencao-remuneracoes.sql";
    private static final String SUBVENCAO_ARQUIVOS = "db/sql/contab/subvencao-arquivos.sql";
    private static final String CERTIDAO_ARQUIVOS = "db/sql/contab/certidao-arquivos.sql";
    private static final String SUBVENCAO_PRESTACAO_CONTAS_ARQUIVOS = "db/sql/contab/subvencao-prestacao-contas-arquivos.sql";
    private static final String SUBVENCAO_ADITIVO_ARQUIVOS = "db/sql/contab/subvencao-aditivo-arquivos.sql";
    private static final String SUBVENCAO_ARQUIVO_SIT = "db/sql/contab/subvencao-arquivo-sit.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final ArquivoService arquivoService;
    private final AdiantamentoRepository adiantamentoRepository;

    @Autowired
    public SubvencaoRepositoryImpl(DatasourceWrapper datasourceWrapper, ArquivoService arquivoService, AdiantamentoRepository adiantamentoRepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.arquivoService = arquivoService;
        this.adiantamentoRepository = adiantamentoRepository;
    }

    public Page<SubvencaoDTO> findSubvencoes(SubvencaoParams params, Pageable pageable) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCOES));
        sql.append(this.montaFiltros(params));
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" ORDER BY  S.ENTIDADE, S.SUBVENCAO, S.EXERCICIO DESC, S.NOMEBENEFICIARIO ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        List subvencoes = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(this.getSqlCount(sql.toString()), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(subvencoes, pageable, total.longValue());
    }

    public SubvencaoDTO findSubvencao(SubvencaoParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCOES));
        if (Objects.nonNull(params.getSubvencao()) && Objects.nonNull(params.getAnoSubvencao())) {
            query.append(" AND S.SUBVENCAO = :subvencao AND S.ANOSUBVENCAO = :anoSubvencao and S.IDTIPO= :tipo AND S.EXERCICIO = :exercicio ");
            return (SubvencaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoDTO.class));
        }
        return new SubvencaoDTO();
    }

    public List<EmpenhoDTO> findValoresLiberados(SubvencaoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_VALORES));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EmpenhoDTO.class));
    }

    public List<SubvencaoSituacaoDTO> findPrestacoesContas(SubvencaoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_PRESTACAO_CONTAS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString().concat(" ORDER BY S.SEQUENCIA"), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoSituacaoDTO.class));
    }

    public SubvencaoSituacaoDTO findPrestacaoContas(PrestacaoContasParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_PRESTACAO_CONTAS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return (SubvencaoSituacaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql.toString().concat(" AND S.SEQUENCIA = :sequencia"), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoSituacaoDTO.class));
    }

    public List<ArquivoDTO> findPrestacaoContasAnexo(PrestacaoContasParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_PRESTACAO_CONTAS_ARQUIVOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoDTO.class));
    }

    public List<SubvencaoAditivoDTO> findAditivos(SubvencaoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_ADITIVOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString().concat(" ORDER BY S.ANOADITIVO, S.NUMEROADITIVO"), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoAditivoDTO.class));
    }

    public SubvencaoAditivoDTO findAditivo(AditivoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_ADITIVOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return (SubvencaoAditivoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql.toString().concat(" AND S.NUMEROADITIVO = :numeroAditivo AND S.ANOADITIVO = :anoAditivo"), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoAditivoDTO.class));
    }

    public List<ArquivoDTO> findAditivoAnexos(AditivoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_ADITIVO_ARQUIVOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoDTO.class));
    }

    public List<SubvencaoRemuneracaoDTO> findRemuneracoes(SubvencaoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_REMUNERACOES).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoRemuneracaoDTO.class));
    }

    public List<SubvencaoSituacaoDetalheDTO> findSituacoes(SubvencaoParams params) {
        return List.of();
    }

    public List<ArquivoDTO> findSubvencaoAnexo(SubvencaoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_ARQUIVOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoDTO.class));
    }

    public List<ArquivoDTO> findCertidaoAnexo(SubvencaoParams params) {
        StringBuilder filtros;
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)CERTIDAO_ARQUIVOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()));
        if (Objects.nonNull(params.getChaveAutenticacao())) {
            filtros = new StringBuilder();
            filtros.append(SqlUtils.andEqual((String)"${db.contabilidade.schema}", (String)"SC.CHAVE_AUTENTICACAO", (String)params.getChaveAutenticacao()));
            sql.append(filtros.toString());
        }
        if (Objects.nonNull(params.getCnpj())) {
            filtros = new StringBuilder();
            filtros.append(SqlUtils.andEqual((String)"${db.contabilidade.schema}", (String)"F.CNPJ", (String)params.getCnpj()));
            sql.append(filtros.toString());
        }
        if (Objects.isNull(params.getChaveAutenticacao()) && Objects.isNull(params.getCnpj())) {
            return Collections.emptyList();
        }
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoDTO.class));
    }

    public Page<SubvencaoArquivoSitDTO> findSubvencaoArquivoSit(FindPessoalParams params, Pageable pageable) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)SUBVENCAO_ARQUIVO_SIT));
        sql.append(this.montaFiltroSubvencaoArquivo(params));
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" ORDER BY S.CODIGO DESC ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        List subvencoes = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(SubvencaoArquivoSitDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(this.getSqlCount(sql.toString()), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(subvencoes, pageable, total.longValue());
    }

    private String getSqlCount(String sql) {
        return "SELECT COUNT(1) TOTAL FROM (" + sql + ") T";
    }

    private String montaFiltros(SubvencaoParams params) {
        StringBuilder filtros = new StringBuilder();
        if (Objects.nonNull(params.getSubvencao())) {
            filtros.append(" AND S.SUBVENCAO = :subvencao ");
        }
        if (Objects.nonNull(params.getAnoSubvencao())) {
            filtros.append(" AND S.ANOSUBVENCAO = :anoSubvencao ");
        }
        if (Objects.nonNull(params.getTipo())) {
            filtros.append(" AND S.IDTIPO = :tipo ");
        }
        if (Objects.nonNull(params.getDataAssinatura())) {
            filtros.append(" AND CAST(S.DATACELEBRACAO AS DATE) = :dataAssinatura ");
        }
        filtros.append(SqlUtils.andLike((String)"${db.contabilidade.schema}", (String)"S.NOMEBENEFICIARIO", (String)params.getNomeBeneficiario()));
        filtros.append(SqlUtils.andLike((String)"${db.contabilidade.schema}", (String)"S.OBJETO", (String)params.getObjeto()));
        filtros.append(SqlUtils.andEqual((String)"${db.contabilidade.schema}", (String)"F.CNPJ", (String)params.getCnpj()));
        return filtros.toString();
    }

    public String montaFiltroSubvencaoArquivo(FindPessoalParams params) {
        StringBuilder filtros = new StringBuilder();
        if (Objects.nonNull(params.getAnoSubvencao().orElse(null)) || Objects.nonNull(params.getSubvencao().orElse(null))) {
            filtros.append(" WHERE  S.EXERCICIO >= :exercicio ");
        } else {
            filtros.append(" WHERE  S.EXERCICIO = :exercicio ");
        }
        filtros.append(" AND S.ENTIDADE = :entidade ");
        params.getAnoSubvencao().ifPresent(item -> filtros.append(" AND S.ANOSUBVENCAO = :anoSubvencao "));
        params.getSubvencao().ifPresent(item -> filtros.append(" AND S.SUBVENCAO = :subvencao "));
        params.getNome().ifPresent(item -> filtros.append(" AND LOWER(${db.contabilidade.schema}.tiraacento(S.FAVORECIDO)) LIKE LOWER(${db.contabilidade.schema}.tiraacento(:nome)) "));
        return filtros.toString();
    }

    public Page<AdiantamentoPessoalDTO> findPrestacaoContas(FindPessoalParams params, Pageable pageable) {
        return this.adiantamentoRepository.findAdiantamentos(params, pageable);
    }
}

