/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioBemBaixaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PatrimonioBemDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.PatrimonioBemRepositoryCustom;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PatrimonioParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class PatrimonioBemRepositoryImpl
implements PatrimonioBemRepositoryCustom {
    private static final String PATRIMONIO_BEM = "db/sql/contab/patrimonio_bem.sql";
    private static final String PATRIMONIO_BEM_BAIXA = "db/sql/contab/patrimonio_bem_baixa.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/contab/ultimaAtualizacaoPatrimonio.sql";
    private static final String ESTADO_CONSERVACAO = "db/sql/contab/estado-conservacao.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public PatrimonioBemRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    private Long getCount(String sql, PatrimonioParams params) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }

    public Page<PatrimonioBemDTO> getListPatrimonioBem(Pageable pageable, PatrimonioParams params) {
        String sql = FileUtils.readResourceAsString((String)PATRIMONIO_BEM);
        String filtro = params.montaFiltro();
        sql = sql.replace("$[FILTRO]", filtro);
        Long total = this.getCount(sql, params);
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY A.DATAAQUISICAO DESC, A.TIPO, ${db.contabilidade.schema}.COMPLETASTRING(A.CHAPA,'0','E',10)");
        String queryPaginado = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List list = this.datasourceWrapper.getJdbcTemplate().query(queryPaginado, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PatrimonioBemDTO.class));
        return new PageImpl(list, pageable, total.longValue());
    }

    public List<PatrimonioBemBaixaDTO> findPatrimonioBemBaixa(PatrimonioParams params) {
        String sql = FileUtils.readResourceAsString((String)PATRIMONIO_BEM_BAIXA);
        String filtro = params.montaFiltro();
        sql = sql.replace("$[FILTRO]", filtro);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PatrimonioBemBaixaDTO.class));
    }

    public List<UltimaAtualizacaoDTO> findUltimasAtualizacoes(FindExercicioParams params) {
        String sql = FileUtils.readResourceAsString((String)ULTIMA_ATUALIZACAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }

    public String findEstadoConservacao(PatrimonioParams params) {
        String sql = FileUtils.readResourceAsString((String)ESTADO_CONSERVACAO);
        List resultado = this.datasourceWrapper.getJdbcTemplate().queryForList(sql, (SqlParameterSource)params.toJdbcParameter(), String.class);
        return resultado.isEmpty() ? null : (String)resultado.get(0);
    }
}

