/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.EmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.HistoricoPadraoDTO;
import br.com.elotech.contabilidade.client.dto.PessoaDTO;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class EmpenhosListaDTO {
    private Long entidade;
    private Long empenho;
    private Long exercicio;
    private String empenhoExercicio;
    private LocalDate data;
    private Long fornecedor;
    private String nome;
    private String historico;
    private BigDecimal valorEmpenhado;
    private BigDecimal valorAnulado;
    private BigDecimal valorLiquidado;
    private BigDecimal valorRetido;
    private BigDecimal valorPago;
    private BigDecimal valorAPagar;
    @JsonIgnore
    private String programatica;
    @JsonIgnore
    private String desdobraDesp;
    @JsonIgnore
    private String subDesdobramento;

    public EmpenhosListaDTO() {
    }

    public EmpenhosListaDTO(BigDecimal valorEmpenhado, BigDecimal valorAnulado, BigDecimal valorLiquidado, BigDecimal valorRetido, BigDecimal valorPago, BigDecimal valorAPagar) {
        this.valorEmpenhado = valorEmpenhado;
        this.valorAnulado = valorAnulado;
        this.valorLiquidado = valorLiquidado;
        this.valorRetido = valorRetido;
        this.valorPago = valorPago;
        this.valorAPagar = valorAPagar;
    }

    public EmpenhosListaDTO(EmpenhoDTO empenho) {
        PessoaDTO credor = empenho.getCredor();
        this.entidade = empenho.getExercicio().getEntidade().getId();
        this.exercicio = empenho.getExercicioOfExercicio();
        this.empenho = empenho.getNumeroEmpenho();
        this.empenhoExercicio = String.format("%s/%s", empenho.getNumeroEmpenho(), empenho.getExercicioOfExercicio());
        this.data = empenho.getData();
        this.fornecedor = credor.getId();
        this.valorEmpenhado = empenho.getValor();
        this.valorAnulado = empenho.getMovimentoAtePeriodo().getSaldoAnulado();
        this.valorLiquidado = empenho.getMovimentoAtePeriodo().getSaldoLiquidacao();
        this.valorRetido = empenho.getMovimentoAtePeriodo().getSaldoRetido();
        this.valorPago = empenho.getMovimentoAtePeriodo().getSaldoPago();
        this.valorAPagar = empenho.getMovimentoAtePeriodo().getEmpenhoPagar();
        this.historico = Optional.ofNullable(empenho.getHistorico()).orElse(new HistoricoPadraoDTO()).getDescricao();
        this.nome = String.format("%s - %s", MaskFormatterUtils.configMaskCnpjCpf((String)credor.getCnpjCpf()), credor.getNome());
        Optional.ofNullable(empenho.getComplementoHistorico()).ifPresent(complemento -> {
            this.historico = String.format("%s - %s", this.historico, complemento);
        });
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public Long getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Long fornecedor) {
        this.fornecedor = fornecedor;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public BigDecimal getValorEmpenhado() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorEmpenhado);
    }

    public void setValorEmpenhado(BigDecimal valorEmpenhado) {
        this.valorEmpenhado = valorEmpenhado;
    }

    public BigDecimal getValorLiquidado() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorLiquidado);
    }

    public void setValorLiquidado(BigDecimal valorLiquidado) {
        this.valorLiquidado = valorLiquidado;
    }

    public BigDecimal getValorPago() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorPago);
    }

    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    public BigDecimal getValorRetido() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorRetido);
    }

    public void setValorRetido(BigDecimal valorRetido) {
        this.valorRetido = valorRetido;
    }

    public BigDecimal getValorAPagar() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorAPagar);
    }

    public void setValorAPagar(BigDecimal valorAPagar) {
        this.valorAPagar = valorAPagar;
    }

    public BigDecimal getValorAnulado() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorAnulado);
    }

    public void setValorAnulado(BigDecimal valorAnulado) {
        this.valorAnulado = valorAnulado;
    }

    public String getEmpenhoExercicio() {
        return this.empenhoExercicio;
    }

    public void setEmpenhoExercicio(String empenhoExercicio) {
        this.empenhoExercicio = empenhoExercicio;
    }

    public String getProgramatica() {
        return this.programatica;
    }

    public void setProgramatica(String programatica) {
        this.programatica = programatica;
    }

    public String getDesdobraDesp() {
        return this.desdobraDesp;
    }

    public void setDesdobraDesp(String desdobraDesp) {
        this.desdobraDesp = desdobraDesp;
    }

    public String getSubDesdobramento() {
        return this.subDesdobramento;
    }

    public void setSubDesdobramento(String subDesdobramento) {
        this.subDesdobramento = subDesdobramento;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public String toString() {
        return "EmpenhosListaDTO(entidade=" + this.getEntidade() + ", empenho=" + this.getEmpenho() + ", exercicio=" + this.getExercicio() + ", empenhoExercicio=" + this.getEmpenhoExercicio() + ", data=" + String.valueOf(this.getData()) + ", fornecedor=" + this.getFornecedor() + ", nome=" + this.getNome() + ", historico=" + this.getHistorico() + ", valorEmpenhado=" + String.valueOf(this.getValorEmpenhado()) + ", valorAnulado=" + String.valueOf(this.getValorAnulado()) + ", valorLiquidado=" + String.valueOf(this.getValorLiquidado()) + ", valorRetido=" + String.valueOf(this.getValorRetido()) + ", valorPago=" + String.valueOf(this.getValorPago()) + ", valorAPagar=" + String.valueOf(this.getValorAPagar()) + ", programatica=" + this.getProgramatica() + ", desdobraDesp=" + this.getDesdobraDesp() + ", subDesdobramento=" + this.getSubDesdobramento() + ")";
    }
}

