/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.LiquidacaoDTO;
import br.com.elotech.core.utils.NumberUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class EmpenhoLiquidacaoDTO {
    private Long entidade;
    private Long exercicio;
    private Long empenho;
    private String unidadeOrcamentaria;
    private Long exercicioLiquidacao;
    private Long noLiquidacao;
    private LocalDate data;
    private BigDecimal valor;
    private BigDecimal valorEstornado;
    private BigDecimal valorRetido;
    private BigDecimal valorPago;

    public EmpenhoLiquidacaoDTO(LiquidacaoDTO liquidacao) {
        this.noLiquidacao = liquidacao.getNumeroLiquidacao();
        this.exercicio = liquidacao.getEmpenho().getExercicioOfExercicio();
        this.empenho = liquidacao.getEmpenho().getNumeroEmpenho();
        this.entidade = liquidacao.getExercicio().getEntidade().getId();
        this.exercicioLiquidacao = liquidacao.getExercicioAno();
        this.data = liquidacao.getDataLiquidacao();
        this.valor = liquidacao.getMovimentoAtePeriodo().getLiquidado();
        this.valorEstornado = liquidacao.getMovimentoAtePeriodo().getLiquidadoAnulado();
        this.valorRetido = liquidacao.getMovimentoAtePeriodo().getRetido();
        this.valorPago = liquidacao.getMovimentoAtePeriodo().getPago();
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    public Long getExercicioLiquidacao() {
        return this.exercicioLiquidacao;
    }

    public void setExercicioLiquidacao(Long exercicioLiquidacao) {
        this.exercicioLiquidacao = exercicioLiquidacao;
    }

    public Long getNoLiquidacao() {
        return this.noLiquidacao;
    }

    public void setNoLiquidacao(Long noLiquidacao) {
        this.noLiquidacao = noLiquidacao;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    public BigDecimal getValor() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valor);
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public BigDecimal getValorEstornado() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorEstornado);
    }

    public void setValorEstornado(BigDecimal valorEstornado) {
        this.valorEstornado = valorEstornado;
    }

    public BigDecimal getValorRetido() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorRetido);
    }

    public void setValorRetido(BigDecimal valorRetido) {
        this.valorRetido = valorRetido;
    }

    public BigDecimal getValorPago() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorPago);
    }

    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public EmpenhoLiquidacaoDTO() {
    }
}

