/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.CidadeDTO;
import br.com.elotech.contabilidade.client.dto.PessoaDTO;
import br.com.elotech.contabilidade.client.enums.TipoPassagem;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class DiariaMovimentacaoPassagensDTO {
    private Long id;
    private Long numeroSolicitacao;
    private LocalDate dataSolicitacao;
    private String nomeServidor;
    private String cargoServidor;
    private String matriculaServidor;
    private String destinoViagem;
    private String uf;
    private String tipoPassagem;
    private String nomeEmpresaFornecedora;
    private Long exercicio;
    private BigDecimal valorAdiantamento;
    private String justificativa;
    private LocalDate dataInicio;
    private LocalDate dataFim;

    public DiariaMovimentacaoPassagensDTO(br.com.elotech.contabilidade.client.dto.DiariaMovimentacaoPassagensDTO diaria) {
        Optional<CidadeDTO> destino = Optional.ofNullable(diaria.getDestinoViagem());
        Optional<PessoaDTO> servidor = Optional.ofNullable(diaria.getServidor());
        this.id = diaria.getId();
        this.numeroSolicitacao = diaria.getNumeroSolicitacao();
        this.dataSolicitacao = diaria.getDataSolicitacao();
        this.nomeServidor = servidor.map(PessoaDTO::getNome).orElse("");
        this.cargoServidor = servidor.map(PessoaDTO::getCargo).orElse("");
        this.matriculaServidor = servidor.map(PessoaDTO::getMatricula).orElse("");
        this.destinoViagem = destino.map(CidadeDTO::getDescricao).orElse("");
        this.uf = destino.map(CidadeDTO::getUf).orElse("");
        this.tipoPassagem = Optional.ofNullable(diaria.getTipoPassagem()).map(TipoPassagem::getDescricao).orElse("");
        this.nomeEmpresaFornecedora = Optional.ofNullable(diaria.getEmpresaFornecedora()).map(PessoaDTO::getNome).orElse("");
        this.exercicio = diaria.getExercicio().getExercicio();
        this.valorAdiantamento = diaria.getValorAdiantamento();
        this.justificativa = diaria.getJustificativa();
        this.dataInicio = diaria.getDataInicio();
        this.dataFim = diaria.getDataFim();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    @Generated
    public LocalDate getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    @Generated
    public String getNomeServidor() {
        return this.nomeServidor;
    }

    @Generated
    public String getCargoServidor() {
        return this.cargoServidor;
    }

    @Generated
    public String getMatriculaServidor() {
        return this.matriculaServidor;
    }

    @Generated
    public String getDestinoViagem() {
        return this.destinoViagem;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public String getTipoPassagem() {
        return this.tipoPassagem;
    }

    @Generated
    public String getNomeEmpresaFornecedora() {
        return this.nomeEmpresaFornecedora;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public BigDecimal getValorAdiantamento() {
        return this.valorAdiantamento;
    }

    @Generated
    public String getJustificativa() {
        return this.justificativa;
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public DiariaMovimentacaoPassagensDTO(Long id, Long numeroSolicitacao, LocalDate dataSolicitacao, String nomeServidor, String cargoServidor, String matriculaServidor, String destinoViagem, String uf, String tipoPassagem, String nomeEmpresaFornecedora, Long exercicio, BigDecimal valorAdiantamento, String justificativa, LocalDate dataInicio, LocalDate dataFim) {
        this.id = id;
        this.numeroSolicitacao = numeroSolicitacao;
        this.dataSolicitacao = dataSolicitacao;
        this.nomeServidor = nomeServidor;
        this.cargoServidor = cargoServidor;
        this.matriculaServidor = matriculaServidor;
        this.destinoViagem = destinoViagem;
        this.uf = uf;
        this.tipoPassagem = tipoPassagem;
        this.nomeEmpresaFornecedora = nomeEmpresaFornecedora;
        this.exercicio = exercicio;
        this.valorAdiantamento = valorAdiantamento;
        this.justificativa = justificativa;
        this.dataInicio = dataInicio;
        this.dataFim = dataFim;
    }

    @Generated
    public DiariaMovimentacaoPassagensDTO() {
    }
}

