/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.oxy.adm.patrimonio.client.portal.PatrimonioArquivoOxyDTO;
import br.com.elotech.oxy.adm.patrimonio.client.portal.PatrimonioBemOxy;
import br.com.elotech.portaltransparencia.contabportal.domain.Comodato;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBemArquivo;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioBemPK;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioImovel;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.TipoAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.TipoBemEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="siscop.PAT_BEM")
public class PatrimonioBem
implements EloEntity<PatrimonioBemPK>,
Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private PatrimonioBemPK id;
    private BigDecimal valorAtual;
    private BigDecimal valorAquisicao;
    @Length(max=50)
    private @Length(max=50) String localAtual;
    @Length(max=2000)
    private @Length(max=2000) String descricao;
    @Length(max=1)
    @Convert(converter=BooleanToStringConverter.class)
    private @Length(max=1) Boolean baixado;
    @Column(name="DATAAQUISICAO")
    private LocalDate dataAquisicao;
    @Column(name="DATABAIXA")
    private LocalDate dataBaixa;
    @Column(name="PROCESSOBAIXA")
    private String processoBaixa;
    @Transient
    private String justificativa;
    @Transient
    private String nomeComprador;
    @ManyToOne
    private PatrimonioAlienacao incorporacao;
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", insertable=false, updatable=false), @JoinColumn(name="tipo", referencedColumnName="tipo", insertable=false, updatable=false), @JoinColumn(name="bem", referencedColumnName="bem", insertable=false, updatable=false), @JoinColumn(name="chapa", referencedColumnName="chapa", insertable=false, updatable=false)})
    private PatrimonioImovel imovel;
    private Long notaFiscal;
    @Column(name="COMPARTILHA_ENTSN")
    @Length(max=1)
    private @Length(max=1) String compartilha;
    @OneToMany(mappedBy="id.bem")
    private List<PatrimonioBemArquivo> arquivos = new ArrayList();
    @Column(name="PLAQUETAANT")
    @Length(max=20)
    private @Length(max=20) String numeroFrota;
    @Transient
    private String tipoBaixa;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="comodato", referencedColumnName="codigo"))})
    private Comodato comodato;
    @Transient
    private UUID idOxy;
    @Transient
    private String rastreamento;
    @Transient
    private String estadoConservacao;

    public PatrimonioBem(PatrimonioBemOxy patrimonioBemOxy) {
        PatrimonioBemPK idFromOxy = new PatrimonioBemPK();
        idFromOxy.setEntidade(patrimonioBemOxy.getEntidade());
        idFromOxy.setChapa(patrimonioBemOxy.getChapa());
        Optional.ofNullable(patrimonioBemOxy.getTipo()).ifPresent(tipoEnumOxy -> idFromOxy.setTipo(TipoBemEnum.fromOxyValue((String)tipoEnumOxy).portalName));
        this.setId(idFromOxy);
        this.setIdOxy(patrimonioBemOxy.getIdBemOxy());
        this.setBaixado(patrimonioBemOxy.getBaixado());
        this.setDescricao(patrimonioBemOxy.getDescricao());
        this.setDataAquisicao(patrimonioBemOxy.getDataAquisicao());
        this.setDataBaixa(patrimonioBemOxy.getDataBaixa());
        this.setJustificativa(patrimonioBemOxy.getJustificativa());
        this.setLocalAtual(patrimonioBemOxy.getLocalAtual());
        this.setNotaFiscal(patrimonioBemOxy.getNotaFiscal());
        this.setNumeroFrota(patrimonioBemOxy.getNumeroFrota());
        this.setTipoBaixa(patrimonioBemOxy.getTipoBaixa());
        this.setValorAtual(patrimonioBemOxy.getValorAtual());
        this.setValorAquisicao(patrimonioBemOxy.getValorAquisicao());
        this.setRastreamento(patrimonioBemOxy.getRastreamento());
        this.setEstadoConservacao(patrimonioBemOxy.getEstadoConservacao());
        Optional.ofNullable(patrimonioBemOxy.getCompartilha()).ifPresent(compartilhaOxy -> this.setCompartilha(SimNao.fromBoolean((Boolean)compartilhaOxy)));
        Optional.ofNullable(patrimonioBemOxy.getImovel()).ifPresent(patrimonioOxyImovel -> this.setImovel(new PatrimonioImovel(patrimonioOxyImovel)));
        Optional.ofNullable(patrimonioBemOxy.getIncorporacao()).ifPresent(patrimonioAlienacaoOxy -> {
            PatrimonioAlienacao alienacao = new PatrimonioAlienacao();
            alienacao.setTipo(patrimonioAlienacaoOxy.getTipo());
            alienacao.setIdOxy(patrimonioAlienacaoOxy.getIdOxy());
            alienacao.setDescricao(patrimonioAlienacaoOxy.getDescricao());
            alienacao.setTipoAquisicao(TipoAlienacao.fromOxy((String)patrimonioAlienacaoOxy.getTipoAquisicao()));
            this.setIncorporacao(alienacao);
        });
        this.adicionarArquivos(patrimonioBemOxy.getArquivos());
    }

    private void adicionarArquivos(List<PatrimonioArquivoOxyDTO> arquivosDto) {
        ArrayList arquivos = new ArrayList();
        arquivosDto.forEach(arquivoDto -> {
            PatrimonioBemArquivo arquivo = new PatrimonioBemArquivo();
            arquivo.setIdArquivo(arquivoDto.getIdArquivo());
            arquivo.setNomeArquivo(arquivoDto.getNomeArquivo());
            arquivos.add(arquivo);
        });
        this.setArquivos(arquivos);
    }

    public void removerArquivosSigilosos() {
        if (this.getArquivos() == null) {
            return;
        }
        this.setArquivos(this.getArquivos().stream().filter(PatrimonioBemArquivo::arquivosNaoSigilosos).collect(Collectors.toList()));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatrimonioBem)) {
            return false;
        }
        PatrimonioBem other = (PatrimonioBem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PatrimonioBemPK this$id = this.getId();
        PatrimonioBemPK other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatrimonioBem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PatrimonioBemPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public PatrimonioBemPK getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getValorAtual() {
        return this.valorAtual;
    }

    @Generated
    public BigDecimal getValorAquisicao() {
        return this.valorAquisicao;
    }

    @Generated
    public String getLocalAtual() {
        return this.localAtual;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getBaixado() {
        return this.baixado;
    }

    @Generated
    public LocalDate getDataAquisicao() {
        return this.dataAquisicao;
    }

    @Generated
    public LocalDate getDataBaixa() {
        return this.dataBaixa;
    }

    @Generated
    public String getProcessoBaixa() {
        return this.processoBaixa;
    }

    @Generated
    public String getJustificativa() {
        return this.justificativa;
    }

    @Generated
    public String getNomeComprador() {
        return this.nomeComprador;
    }

    @Generated
    public PatrimonioAlienacao getIncorporacao() {
        return this.incorporacao;
    }

    @Generated
    public PatrimonioImovel getImovel() {
        return this.imovel;
    }

    @Generated
    public Long getNotaFiscal() {
        return this.notaFiscal;
    }

    @Generated
    public String getCompartilha() {
        return this.compartilha;
    }

    @Generated
    public List<PatrimonioBemArquivo> getArquivos() {
        return this.arquivos;
    }

    @Generated
    public String getNumeroFrota() {
        return this.numeroFrota;
    }

    @Generated
    public String getTipoBaixa() {
        return this.tipoBaixa;
    }

    @Generated
    public Comodato getComodato() {
        return this.comodato;
    }

    @Generated
    public UUID getIdOxy() {
        return this.idOxy;
    }

    @Generated
    public String getRastreamento() {
        return this.rastreamento;
    }

    @Generated
    public String getEstadoConservacao() {
        return this.estadoConservacao;
    }

    @Generated
    public void setId(PatrimonioBemPK id) {
        this.id = id;
    }

    @Generated
    public void setValorAtual(BigDecimal valorAtual) {
        this.valorAtual = valorAtual;
    }

    @Generated
    public void setValorAquisicao(BigDecimal valorAquisicao) {
        this.valorAquisicao = valorAquisicao;
    }

    @Generated
    public void setLocalAtual(String localAtual) {
        this.localAtual = localAtual;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setBaixado(Boolean baixado) {
        this.baixado = baixado;
    }

    @Generated
    public void setDataAquisicao(LocalDate dataAquisicao) {
        this.dataAquisicao = dataAquisicao;
    }

    @Generated
    public void setDataBaixa(LocalDate dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    @Generated
    public void setProcessoBaixa(String processoBaixa) {
        this.processoBaixa = processoBaixa;
    }

    @Generated
    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Generated
    public void setNomeComprador(String nomeComprador) {
        this.nomeComprador = nomeComprador;
    }

    @Generated
    public void setIncorporacao(PatrimonioAlienacao incorporacao) {
        this.incorporacao = incorporacao;
    }

    @Generated
    public void setImovel(PatrimonioImovel imovel) {
        this.imovel = imovel;
    }

    @Generated
    public void setNotaFiscal(Long notaFiscal) {
        this.notaFiscal = notaFiscal;
    }

    @Generated
    public void setCompartilha(String compartilha) {
        this.compartilha = compartilha;
    }

    @Generated
    public void setArquivos(List<PatrimonioBemArquivo> arquivos) {
        this.arquivos = arquivos;
    }

    @Generated
    public void setNumeroFrota(String numeroFrota) {
        this.numeroFrota = numeroFrota;
    }

    @Generated
    public void setTipoBaixa(String tipoBaixa) {
        this.tipoBaixa = tipoBaixa;
    }

    @Generated
    public void setComodato(Comodato comodato) {
        this.comodato = comodato;
    }

    @Generated
    public void setIdOxy(UUID idOxy) {
        this.idOxy = idOxy;
    }

    @Generated
    public void setRastreamento(String rastreamento) {
        this.rastreamento = rastreamento;
    }

    @Generated
    public void setEstadoConservacao(String estadoConservacao) {
        this.estadoConservacao = estadoConservacao;
    }

    @Generated
    public String toString() {
        return "PatrimonioBem(id=" + String.valueOf(this.getId()) + ", valorAtual=" + String.valueOf(this.getValorAtual()) + ", valorAquisicao=" + String.valueOf(this.getValorAquisicao()) + ", localAtual=" + this.getLocalAtual() + ", descricao=" + this.getDescricao() + ", baixado=" + this.getBaixado() + ", dataAquisicao=" + String.valueOf(this.getDataAquisicao()) + ", dataBaixa=" + String.valueOf(this.getDataBaixa()) + ", processoBaixa=" + this.getProcessoBaixa() + ", justificativa=" + this.getJustificativa() + ", nomeComprador=" + this.getNomeComprador() + ", incorporacao=" + String.valueOf(this.getIncorporacao()) + ", imovel=" + String.valueOf(this.getImovel()) + ", notaFiscal=" + this.getNotaFiscal() + ", compartilha=" + this.getCompartilha() + ", arquivos=" + String.valueOf(this.getArquivos()) + ", numeroFrota=" + this.getNumeroFrota() + ", tipoBaixa=" + this.getTipoBaixa() + ", comodato=" + String.valueOf(this.getComodato()) + ", idOxy=" + String.valueOf(this.getIdOxy()) + ", rastreamento=" + this.getRastreamento() + ", estadoConservacao=" + this.getEstadoConservacao() + ")";
    }

    @Generated
    public PatrimonioBem() {
    }
}

