/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.stereotype.Component;

@Component
public class TenantCacheKeyGenerator
implements KeyGenerator {
    public Object generate(Object target, Method method, Object ... params) {
        if (Objects.nonNull(TenantContextHolder.getTenant())) {
            Object param;
            if (params.length == 0) {
                return TenantContextHolder.getCurrentTenantId();
            }
            if (params.length == 1 && (param = params[0]) != null && !param.getClass().isArray()) {
                return new SimpleKey(new Object[]{TenantContextHolder.getCurrentTenantId(), param});
            }
            Object[] paramsWithTenant = ArrayUtils.insert((int)0, (Object[])params, (Object[])new Object[]{TenantContextHolder.getCurrentTenantId()});
            return new SimpleKey(paramsWithTenant);
        }
        return SimpleKeyGenerator.generateKey((Object[])params);
    }
}

