/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class ConditionalOpenEntityManagerInViewInterceptor
implements WebRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConditionalOpenEntityManagerInViewInterceptor.class);
    private final OpenEntityManagerInViewInterceptor delegate;
    private final List<String> excludedPatterns;

    public ConditionalOpenEntityManagerInViewInterceptor(OpenEntityManagerInViewInterceptor delegate, List<String> excludedPatterns) {
        this.delegate = delegate;
        this.excludedPatterns = excludedPatterns;
    }

    public ConditionalOpenEntityManagerInViewInterceptor(OpenEntityManagerInViewInterceptor delegate, String ... excludedPatterns) {
        this(delegate, Arrays.asList(excludedPatterns));
    }

    public void preHandle(WebRequest request) throws Exception {
        String servletPath = this.getServletPath(request);
        if (this.shouldExclude(servletPath)) {
            log.debug("Skipping open-in-view for servlet path: {}", (Object)servletPath);
            request.setAttribute("SKIP_OPEN_IN_VIEW", (Object)true, 0);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Applying open-in-view for servlet path: {}", (Object)servletPath);
        }
        this.delegate.preHandle(request);
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
        Boolean skipOpenInView = (Boolean)request.getAttribute("SKIP_OPEN_IN_VIEW", 0);
        if (Boolean.TRUE.equals(skipOpenInView)) {
            return;
        }
        this.delegate.postHandle(request, model);
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
        Boolean skipOpenInView = (Boolean)request.getAttribute("SKIP_OPEN_IN_VIEW", 0);
        if (Boolean.TRUE.equals(skipOpenInView)) {
            log.debug("Skipped open-in-view cleanup");
            return;
        }
        this.delegate.afterCompletion(request, ex);
    }

    private String getServletPath(WebRequest request) {
        NativeWebRequest nativeRequest;
        HttpServletRequest httpRequest;
        if (request instanceof NativeWebRequest && (httpRequest = (HttpServletRequest)(nativeRequest = (NativeWebRequest)request).getNativeRequest(HttpServletRequest.class)) != null) {
            String servletPath = httpRequest.getServletPath();
            if (log.isDebugEnabled()) {
                log.debug("Extracted paths - RequestURI: {}, ContextPath: {}, ServletPath: {}", new Object[]{httpRequest.getRequestURI(), httpRequest.getContextPath(), servletPath});
            }
            return servletPath;
        }
        log.warn("Could not cast WebRequest to NativeWebRequest, falling back to description parsing");
        String description = request.getDescription(false);
        if (description != null && description.startsWith("uri=")) {
            String uri = description.substring(4);
            int queryIndex = uri.indexOf(63);
            if (queryIndex > 0) {
                uri = uri.substring(0, queryIndex);
            }
            return uri;
        }
        return "";
    }

    private boolean shouldExclude(String servletPath) {
        return this.excludedPatterns.stream().anyMatch(pattern -> this.matchesPattern(servletPath, pattern));
    }

    private boolean matchesPattern(String path, String pattern) {
        if (pattern.equals(path)) {
            return true;
        }
        if (pattern.contains("*")) {
            String regex = pattern.replace(".", "\\.").replace("*", ".*");
            return path.matches(regex);
        }
        return path.startsWith(pattern);
    }
}

