/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@EnableCaching
@Profile(value={"cloud"})
public class CloudCacheConfig {
    public static final long TIMEOUT = 30L;
    @Autowired
    private final RedisProperties redisProperties;
    @Value(value="${cache.config.entryTtl:10M}")
    private Duration defaultDuration;

    @Bean
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory, ObjectMapper objectMapper) {
        ObjectMapper mapper = objectMapper.copy();
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.setFailOnUnknownId(false);
        mapper.setFilterProvider((FilterProvider)filterProvider);
        BasicPolymorphicTypeValidator typeValidator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).build();
        mapper.activateDefaultTyping((PolymorphicTypeValidator)typeValidator, ObjectMapper.DefaultTyping.NON_FINAL);
        RedisCacheWriter cacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory, (BatchStrategy)BatchStrategies.scan((int)1000));
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(cacheName -> "oxy-portaltransparencia:" + cacheName + ":").entryTtl(this.defaultDuration).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer(mapper)));
        HashMap<String, RedisCacheConfiguration> cacheConfigurations = new HashMap<String, RedisCacheConfiguration>();
        cacheConfigurations.put("publicacoes", defaultCacheConfig);
        cacheConfigurations.put("despesas", defaultCacheConfig);
        cacheConfigurations.put("nivel_modelo_despesa", defaultCacheConfig);
        cacheConfigurations.put("receitas", defaultCacheConfig);
        cacheConfigurations.put("receitas_valores", defaultCacheConfig);
        cacheConfigurations.put("avaliacao_ppa", defaultCacheConfig);
        cacheConfigurations.put("dashboard_receitas_empenhados", defaultCacheConfig);
        cacheConfigurations.put("dashboard_valor_receita", defaultCacheConfig);
        cacheConfigurations.put("dashboard_valor_despesa", defaultCacheConfig);
        cacheConfigurations.put("receita_x_despesa_receitas_empenhadas", defaultCacheConfig);
        cacheConfigurations.put("receita_x_despesa_empenhado_atual", defaultCacheConfig);
        cacheConfigurations.put("servidores_webservice", defaultCacheConfig.entryTtl(Duration.ofHours(24L)));
        cacheConfigurations.put("permutas_webservice", defaultCacheConfig.entryTtl(Duration.ofHours(24L)));
        cacheConfigurations.put("estagiarios_webservice", defaultCacheConfig.entryTtl(Duration.ofHours(24L)));
        return RedisCacheManager.builder((RedisCacheWriter)cacheWriter).cacheDefaults(defaultCacheConfig).withInitialCacheConfigurations(cacheConfigurations).enableStatistics().build();
    }

    @Bean
    public LettuceConnectionFactory redisClusterConnectionFactory() {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(20);
        poolConfig.setMaxIdle(10);
        poolConfig.setMinIdle(5);
        poolConfig.setTestOnBorrow(true);
        LettucePoolingClientConfiguration.LettucePoolingSslClientConfigurationBuilder config = LettucePoolingClientConfiguration.builder().commandTimeout(Optional.ofNullable(this.redisProperties.getTimeout()).orElse(Duration.ofSeconds(30L))).shutdownTimeout(Duration.ofMillis(100L)).poolConfig(poolConfig).useSsl().disablePeerVerification();
        return new LettuceConnectionFactory(new RedisClusterConfiguration(List.of(String.format("%s:%s", this.redisProperties.getHost(), this.redisProperties.getPort()))), (LettuceClientConfiguration)config.build());
    }

    @Generated
    public CloudCacheConfig(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }
}

