/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.agendamento.client.AgendamentoFeignClient;
import br.com.elotech.agendamento.client.dto.AgendamentoDTO;
import br.com.elotech.agendamento.client.dto.AgendamentoJobDTO;
import br.com.elotech.core.context.HeaderContextHolder;
import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"cloud"})
public class CloudCacheClearInitializer
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudCacheClearInitializer.class);
    private static final String JOB_ID = "clear-cache-portal";
    private final Environment environment;
    private final AgendamentoFeignClient agendamentoFeignClient;
    private final TenantClient tenantClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ApplicationArguments args) throws Exception {
        String tenant = this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"production"})) ? "elo" : "elotech";
        try {
            this.initializeContext(tenant);
            this.agendamentoFeignClient.find(tenant, JOB_ID).flatMap(AgendamentoJobDTO::getNextRun).ifPresentOrElse(agendamento -> log.info("J\u00e1 existe um job criado com o id {} para o tenant {}", (Object)JOB_ID, (Object)tenant), () -> this.createAgendamento(tenant));
        }
        catch (Exception e) {
            log.error("Erro ao criar agendamento para limpar cache do tenant {}", (Object)tenant, (Object)e);
        }
        finally {
            TenantContextHolder.resetTenant();
            HeaderContextHolder.resetHeaders();
        }
    }

    private void initializeContext(String tenantIdentifier) {
        HeaderContextHolder.setHeaders(new HashMap());
        HeaderContextHolder.addHeader((String)"x-forwarded-host", (String)"%s.elotech.com.br".formatted(tenantIdentifier));
        this.tenantClient.getTenant(tenantIdentifier).ifPresentOrElse(TenantContextHolder::setTenant, () -> log.error("N\u00e3o foi poss\u00edvel encontrar o tenant {} para o portal da transparencia", (Object)tenantIdentifier));
    }

    private void createAgendamento(String tenant) {
        log.info("Criando agendamento para limpar cache do tenant {}", (Object)tenant);
        this.agendamentoFeignClient.create(AgendamentoDTO.builder().id(JOB_ID).tenant(tenant).cron("0 0 3 * * *").url("/portaltransparencia-api/admin/cache").httpMethod(HttpMethod.DELETE).build());
        log.info("Agendamento criado com sucesso");
    }

    @Generated
    public CloudCacheClearInitializer(Environment environment, AgendamentoFeignClient agendamentoFeignClient, TenantClient tenantClient) {
        this.environment = environment;
        this.agendamentoFeignClient = agendamentoFeignClient;
        this.tenantClient = tenantClient;
    }
}

