/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ResponsavelDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindResponsavelParams;
import br.com.elotech.portaltransparencia.comprasportal.service.ResponsavelService;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/responsaveis"})
public class ResponsavelAdmResource {
    private final ResponsavelService responsavelService;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;

    public ResponsavelAdmResource(ResponsavelService responsavelService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.responsavelService = responsavelService;
    }

    @GetMapping
    public ResponseEntity<Page<ResponsavelDTO>> findAll(@Valid FindResponsavelParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.responsavelService.findAll(params, pageable));
    }

    @GetMapping(path={"/contrato"})
    public ResponseEntity<List<ResponsavelDTO>> findResponsaveis(FindContratoParams params) {
        return ResponseEntity.ok((Object)this.responsavelService.findResponsaveis(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findAllExport(HttpServletRequest request, HttpServletResponse response, @Valid FindResponsavelParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.responsavelService.findAll(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(params.getEntidade())) {
            Optional entidadeObj = this.entidadeRepository.findById((Object)params.getEntidade());
            entidadeObj.ifPresent(entidade -> reportParam.setNomeEntidade(entidade.getNome()));
        }
        reportParam.setReportTitle("Respons\u00e1veis");
        reportParam.setClazzDTO(ResponsavelDTO.class);
        String headerFields = "Ocupante,Cargo,Tipo Ato,Nr. Contrato,Dt. Inicio,Dt. T\u00e9rmino,Dt. Final Vig\u00eancia,Situa\u00e7\u00e3o";
        String fields = "ocupante,descricaoCargo,descricaoTipoAto,displayContrato,dataInicio,dataTermino,vigencia,situacao";
        float[] fieldsPerc = new float[]{1.8f, 1.8f, 0.7f, 0.7f, 0.7f, 0.7f, 0.7f, 0.7f};
        int[] fieldTab = new int[]{100, 100, 20, 20, 15, 15, 15, 15};
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

