/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.portaltransparencia.comprasportal.service.PublicacaoService;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupo;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PublicacaoParams;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/publicacoes"})
public class PublicacaoResource {
    private final PublicacaoService publicacaoService;

    public PublicacaoResource(PublicacaoService publicacaoService) {
        this.publicacaoService = publicacaoService;
    }

    @GetMapping(params={"entidade", "exercicio"})
    public ResponseEntity<List<PublicacaoGrupo>> loadPublicacoes(PublicacaoParams params) {
        return ResponseEntity.ok((Object)this.publicacaoService.loadPublicacoes(params));
    }

    @GetMapping(value={"/{idGrupo}"}, params={"entidade", "exercicio"})
    public ResponseEntity<List<PublicacaoGrupo>> findPublicacoesGrupo(PublicacaoParams params, @PathVariable(value="idGrupo") Long idGrupo) {
        params.setIdGrupo(idGrupo);
        return ResponseEntity.ok((Object)this.publicacaoService.loadPublicacoesGrupo(params));
    }

    @GetMapping(value={"/{idGrupo}/{idSubGrupo}"}, params={"entidade", "exercicio"})
    public ResponseEntity<List<PublicacaoGrupo>> findPublicacoesGrupoSubGrupo(PublicacaoParams params, @PathVariable(value="idGrupo") Long idGrupo, @PathVariable(value="idSubGrupo") Long idSubGrupo) {
        params.setIdGrupo(idGrupo);
        params.setIdSubGrupo(idSubGrupo);
        return ResponseEntity.ok((Object)this.publicacaoService.loadPublicacoesGrupo(params));
    }
}

