/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PcaDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PcaItemDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindPcaParams;
import br.com.elotech.portaltransparencia.comprasportal.service.PcaService;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/pca"})
public class PcaResource {
    private final PcaService service;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;

    public PcaResource(PcaService service, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<Page<PcaDTO>> findAll(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, @Valid FindPcaParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findAll(params, pageable));
    }

    @GetMapping(value={"/detalhe"}, params={"entidade", "exercicio", "planoContratacao"})
    public ResponseEntity<PcaDTO> findPca(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, @RequestParam(value="planoContratacao") Long planoContratacao, @Valid FindPcaParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setPlanoContratacao(planoContratacao);
        return ResponseEntity.ok((Object)this.service.findPca(params));
    }

    @GetMapping(value={"/itens"}, params={"entidade", "exercicio", "planoContratacao"})
    public ResponseEntity<Page<PcaItemDTO>> findPcaItens(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, @RequestParam(value="planoContratacao") Long planoContratacao, @Valid FindPcaParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setPlanoContratacao(planoContratacao);
        return ResponseEntity.ok((Object)this.service.findPcaItens(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findAllExport(HttpServletRequest request, HttpServletResponse response, @Valid FindPcaParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.service.findAll(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(params.getEntidade())) {
            Optional entidadeObj = this.entidadeRepository.findById((Object)params.getEntidade());
            entidadeObj.ifPresent(entidade -> reportParam.setNomeEntidade(entidade.getNome()));
        }
        reportParam.setReportTitle("PCA - Plano de Contrata\u00e7\u00e3o Anual");
        reportParam.setClazzDTO(PcaDTO.class);
        String headerFields = "N\u00ba PCA,Data,\u00d3rg\u00e3o,Status";
        String fields = "planoContratacao,dataPca,unidadeDescricao,statusDescricao";
        float[] fieldsPerc = new float[]{0.7f, 0.7f, 1.8f, 1.0f};
        int[] fieldTab = new int[]{15, 15, 100, 50};
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/report/itens"})
    public ModelAndView findPcaItensExport(HttpServletRequest request, HttpServletResponse response, @Valid FindPcaParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.service.findPcaItens(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(params.getEntidade())) {
            Optional entidadeObj = this.entidadeRepository.findById((Object)params.getEntidade());
            entidadeObj.ifPresent(entidade -> reportParam.setNomeEntidade(entidade.getNome()));
        }
        reportParam.setReportTitle("PCA - Plano de Contrata\u00e7\u00e3o Anual");
        reportParam.setClazzDTO(PcaItemDTO.class);
        String headerFields = "Item, Data Desejada, Categoria PCA, Classifica\u00e7\u00e3o, Classifica\u00e7\u00e3o Superior, Quantidade, Valor Unit\u00e1rio, Valor Total, Valor Or\u00e7amento";
        String fields = "displayItem, dataPca, categoriaItemPcaDescricao, classificacaoCatalogo, displayClassificacaoSuperior, quantidade, valorUnitario, valorTotal, valorOrcamentoExercicio";
        float[] fieldsPerc = new float[]{1.8f, 0.7f, 0.7f, 0.7f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        int[] fieldTab = new int[]{150, 15, 15, 15, 15, 15, 15, 15, 15};
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

