/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.EntidadeComprasDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoParticipanteDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoSeiDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.MidiaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.LicitacoesParticipanteParams;
import br.com.elotech.portaltransparencia.comprasportal.service.LicitacaoParticipanteService;
import br.com.elotech.portaltransparencia.comprasportal.service.LicitacaoService;
import br.com.elotech.portaltransparencia.comprasportal.service.impl.EntidadeComprasService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/licitacoes"})
public class LicitacaoResource {
    private final LicitacaoService licitacaoService;
    private final LicitacaoParticipanteService licitacaoParticipanteService;
    private final ElotechProperties elotechProperties;
    private final EntidadeComprasService entidadeComprasService;
    private final BaseExport baseExport;

    @Autowired
    public LicitacaoResource(LicitacaoService licitacaoService, LicitacaoParticipanteService licitacaoParticipanteService, ElotechProperties elotechProperties, EntidadeComprasService entidadeComprasService, BaseExport baseExport) {
        this.licitacaoService = licitacaoService;
        this.licitacaoParticipanteService = licitacaoParticipanteService;
        this.elotechProperties = elotechProperties;
        this.entidadeComprasService = entidadeComprasService;
        this.baseExport = baseExport;
    }

    @GetMapping
    public ResponseEntity<Page<LicitacaoDTO>> findListLicitacoes(@RequestParam(value="entidade", required=false) Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio, @Valid FindLicitacaoParams findLicitacaoParams, Pageable pageable) {
        findLicitacaoParams.setEntidade(entidade);
        findLicitacaoParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.licitacaoService.findLicitacoes(findLicitacaoParams, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportListLicitacoes(HttpServletRequest request, HttpServletResponse response, @Valid FindLicitacaoParams findLicitacaoParams, Pageable pageable) throws Throwable {
        EntidadeComprasDTO entidadeCompras;
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.licitacaoService.findLicitacoes(findLicitacaoParams, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(findLicitacaoParams.getEntidade()) && Objects.nonNull(entidadeCompras = this.entidadeComprasService.findOne(findLicitacaoParams.getEntidade()))) {
            reportParam.setNomeEntidade(entidadeCompras.getNome());
        }
        reportParam.setReportTitle("Listagem das Licita\u00e7\u00f5es");
        reportParam.setClazzDTO(LicitacaoDTO.class);
        reportParam.setHeaderFields("Abertura,Modalidade,N\u00famero,Natureza,Processo Adm,Valor Maximo, Situa\u00e7\u00e3o,Objeto,Recurso,Valor Homologado");
        reportParam.setFields("dataAbertura,descricao,displayLicitacao,natureza,displayProcessoAdm,valorMaximo,tipoCancelamento,objeto,hasRecurso,totalVencido");
        float[] fieldsPerc = new float[]{0.8f, 1.0f, 1.0f, 2.1f, 0.8f, 0.8f, 1.0f, 1.7f, 0.8f, 0.8f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 100, 10, 30, 30, 20, 50, 490, 10, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(findLicitacaoParams.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{tipoLicitacao}/{licitacao}"})
    public ResponseEntity<LicitacaoDTO> findListLicitacao(FindLicitacaoParams params) {
        return ResponseEntity.ok((Object)this.licitacaoService.findLicitacao(params));
    }

    @GetMapping(value={"/midias"}, params={"entidade", "exercicio", "tipoLicitacao", "licitacao"})
    public ResponseEntity<List<MidiaLicitacaoDTO>> findMidia(FindLicitacaoParams params) {
        List listMidia = this.licitacaoService.findMidia(params);
        return ResponseEntity.ok((Object)listMidia);
    }

    @GetMapping(value={"/{method}"}, params={"entidade", "exercicio", "tipoLicitacao", "licitacao"})
    public ResponseEntity<?> findByTipoDetalhe(@PathVariable(value="method") String method, FindLicitacaoParams params) {
        Method methodReference = MethodUtils.getAccessibleMethod(LicitacaoService.class, (String)String.format("find%s", StringUtils.capitalize((String)method)), FindLicitacaoParams.class);
        if (methodReference == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)methodReference.invoke((Object)this.licitacaoService, params));
    }

    @GetMapping(value={"/participantes"})
    public ResponseEntity<List<br.com.elotech.oxy.adm.compras.client.portal.LicitacaoParticipanteDTO>> findLicitacoesParticipantes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid FindLicitacaoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.licitacaoService.findAllByLicitacao(params));
    }

    @GetMapping(value={"/participantes-search"})
    public ResponseEntity<Page<br.com.elotech.oxy.adm.compras.client.portal.LicitacaoParticipanteDTO>> findByRsql(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.licitacaoService.findByRsql(search, pageable));
    }

    @GetMapping(value={"/participante"})
    public ResponseEntity<LicitacaoParticipanteDTO> findLicitacoesParticipante(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid LicitacoesParticipanteParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.licitacaoParticipanteService.findParticipante(params));
    }

    @GetMapping(value={"/participante-licitacoes/{participante}"})
    public ResponseEntity<br.com.elotech.oxy.adm.compras.client.portal.LicitacaoParticipanteDTO> findLicitacoesByPaciente(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @PathVariable(value="participante") Long participante) {
        return ResponseEntity.ok((Object)this.licitacaoService.findAllLicitacoesByParticipante(participante, entidade, exercicio));
    }

    @GetMapping(value={"/ultimas-atualizacoes"})
    public ResponseEntity<List<UltimaAtualizacaoDTO>> ultimasAtualizacoes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindExercicioParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.licitacaoService.findUltimasAtualizacoes(params));
    }

    @GetMapping(value={"/participantes/report/{exportType}"})
    public ModelAndView exportListParticipantes(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false, defaultValue="") String search, @PathVariable(value="exportType") String exportType, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.licitacaoService.findByRsql(search, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        reportParam.setReportTitle("Listagem das Participantes");
        reportParam.setClazzDTO(br.com.elotech.oxy.adm.compras.client.portal.LicitacaoParticipanteDTO.class);
        reportParam.setHeaderFields("Raz\u00e3o Social,Nome Fantasia,CNPJ/CPF");
        reportParam.setFields("razaoSocial,nomeFantasia,cnpj");
        float[] fieldsPerc = new float[]{1.0f, 1.0f, 0.6f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{100, 100, 10};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/sei"})
    public ResponseEntity<List<LicitacaoSeiDTO>> findSei(@Valid FindLicitacaoParams params) {
        return ResponseEntity.ok((Object)this.licitacaoService.findSei(params));
    }
}

