/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.oxy.adm.compras.client.portal.LicitacaoParticipanteDTO;
import br.com.elotech.oxy.adm.compras.client.portal.LicitacaoPortalDTO;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AtaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CertidaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoSeiDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.MidiaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ParecerDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PrecoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PublicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.utils.RsqlToJdbcParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class LicitacaoRepositoryImpl
implements LicitacaoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicitacaoRepositoryImpl.class);
    private static final String LICITACOES = "db/sql/compras/licitacoes.sql";
    private static final String LICITACOES_COUNT = "db/sql/compras/licitacoes_count.sql";
    private static final String LICITACAO = "db/sql/compras/licitacao.sql";
    private static final String PARECERES = "db/sql/compras/pareceres.sql";
    private static final String COTACOES = "db/sql/compras/cotacoes.sql";
    private static final String MIDIAS = "db/sql/compras/midias.sql";
    private static final String PUBLICACOES = "db/sql/compras/publicacoes.sql";
    private static final String ATASLICITACAO = "db/sql/compras/atasLicitacao.sql";
    private static final String ATASREGISTROPRECO = "db/sql/compras/atasRegistroPreco.sql";
    private static final String ATASSESSAOPREGAO = "db/sql/compras/atasSessaoPregao.sql";
    private static final String CERTIDOES = "db/sql/compras/certidoes.sql";
    private static final String PRECOS = "db/sql/compras/precos.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/compras/ultimaAtualizacaoLicitacao.sql";
    private static final String RECURSOS = "db/sql/compras/recursos.sql";
    private static final String RECURSOARQUIVOS = "db/sql/compras/recursoArquivos.sql";
    private static final String LISTAARQUIVOS = "db/sql/compras/listaArquivos.sql";
    private static final String NUMEROSEI = "db/sql/compras/numeroSei.sql";
    private static final String PARTICIPANTES = "db/sql/compras/participantes.sql";
    private static final String PARTICIPANTE_LICITACOES = "db/sql/compras/participanteLicitacoes.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final PortalParametroRepository portalparametrorepository;

    @Autowired
    public LicitacaoRepositoryImpl(DatasourceWrapper datasourceWrapper, PortalParametroRepository portalparametrorepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.portalparametrorepository = portalparametrorepository;
    }

    public Page<LicitacaoDTO> findLicitacoes(FindLicitacaoParams params, Pageable pageable) {
        StringBuilder where = new StringBuilder(" ");
        if (Objects.isNull(params.getIgnoraExercicioLogado()) || !Boolean.TRUE.equals(params.getIgnoraExercicioLogado())) {
            where.append(" AND L.EXERCICIO = :exercicio ");
            if (SimNao.toBoolean((String)this.portalparametrorepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_FILTRAR_PROC_ADM_EXERCICIO_ATUAL).getValor()).booleanValue()) {
                where.append(" AND L.ANOPROCESSOADM = :exercicio ");
            }
        }
        if (params.getDataAberturaMaior().isPresent()) {
            where = new StringBuilder(" AND L.DATAABERTURA >= :dataAberturaMaior ");
        }
        if (params.getDataAberturaInicio().isPresent() && params.getDataAberturaFim().isPresent()) {
            where.append(" AND L.DATAABERTURA BETWEEN :dataAberturaInicio AND :dataAberturaFim");
        }
        if (Boolean.FALSE.equals(params.getIgnoraEntidadeLogada()) && Objects.nonNull(params.getEntidade())) {
            where.append(" AND L.ENTIDADE = :entidade ");
        }
        String sqlCount = FileUtils.readResourceAsString((String)"db/sql/compras/licitacoes_count.sql") + where;
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/licitacoes.sql") + where;
        StringBuilder query = params.filtrosLicitacao(sql, this.datasourceWrapper.getPlatform());
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)" ORDER BY L.DATAABERTURA DESC, L.NUMEROLICITACAO DESC ");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, sql);
        List licitacoes = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoDTO.class));
        StringBuilder queryCount = params.filtrosLicitacao(sqlCount, this.datasourceWrapper.getPlatform());
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(licitacoes, pageable, total.longValue());
    }

    private void consoleLogger(FindLicitacaoParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public LicitacaoDTO findLicitacao(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/licitacao.sql");
        sql = SimNao.toBoolean((String)this.portalparametrorepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), Parametros.PARAM_LICIT_ENTIDADES_DIFERENTES).getValor()).booleanValue() ? (params.getAnoNadEmpenho().isPresent() ? sql.concat(" AND L.ENTIDADE = (SELECT n.entidadelicitacao                                FROM ${db.compras.schema}.clnad n                                  WHERE n.exercicio          = :anonadempenho                          AND n.exerciciolicitacao = :exercicio                              AND n.numeronad          = :nonadempenho                           AND n.empenho            = :empenho)      ") : sql.concat(" AND L.ENTIDADE = :entidade ")) : sql.concat(" AND L.ENTIDADE = :entidade ");
        if (params.getLicitacao().isPresent()) {
            sql = sql.concat(" AND L.LICITACAO = :licitacao ");
        }
        if (params.getNumeroLicitacao().isPresent()) {
            sql = sql.concat(" AND L.NUMEROLICITACAO = :numeroLicitacao ");
        }
        this.consoleLogger(params, sql);
        return (LicitacaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoDTO.class));
    }

    public List<ParecerDTO> findPareceres(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/pareceres.sql").replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ParecerDTO.class));
    }

    public List<CotacaoLicitacaoDTO> findCotacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/cotacoes.sql").replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        String sqlArquivos = FileUtils.readResourceAsString((String)"db/sql/compras/listaArquivos.sql").replace("schema_eloarquivo", nomeSchemaEloArquivo);
        List cotacoes = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CotacaoLicitacaoDTO.class));
        cotacoes.forEach(cotacaoLicitacaoDTO -> {
            MapSqlParameterSource paramsWhere = new MapSqlParameterSource();
            paramsWhere.addValue("idchave", (Object)String.format("C%d-%d-%d-%d", params.getEntidade(), params.getExercicio(), cotacaoLicitacaoDTO.getCotacao(), cotacaoLicitacaoDTO.getPessoa()), 12);
            cotacaoLicitacaoDTO.setArquivos(this.datasourceWrapper.getJdbcTemplate().query(sqlArquivos, (SqlParameterSource)paramsWhere, (RowMapper)new ElotechBeanPropertyRowMapper(CotacaoArquivoDTO.class)));
        });
        return cotacoes;
    }

    public List<MidiaLicitacaoDTO> findMidia(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/midias.sql");
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new BeanPropertyRowMapper(MidiaLicitacaoDTO.class));
    }

    public List<LicitacaoSeiDTO> findSei(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/numeroSei.sql");
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new BeanPropertyRowMapper(LicitacaoSeiDTO.class));
    }

    public List<PublicacaoLicitacaoDTO> findPublicacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/publicacoes.sql").replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PublicacaoLicitacaoDTO.class));
    }

    public List<AtaLicitacaoDTO> findAtasRegistroPreco(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/atasRegistroPreco.sql").replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AtaLicitacaoDTO.class));
    }

    public List<AtaLicitacaoDTO> findAtasLicitacao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/atasLicitacao.sql").replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AtaLicitacaoDTO.class));
    }

    public List<AtaLicitacaoDTO> findAtasSessaoPregao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/atasSessaoPregao.sql").replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AtaLicitacaoDTO.class));
    }

    public List<CertidaoLicitacaoDTO> findCertidoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/certidoes.sql").replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CertidaoLicitacaoDTO.class));
    }

    public List<PrecoLicitacaoDTO> findPrecos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/precos.sql").replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PrecoLicitacaoDTO.class));
    }

    public List<RecursoLicitacaoDTO> findRecursos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/recursos.sql");
        String sqlArquivos = FileUtils.readResourceAsString((String)"db/sql/compras/recursoArquivos.sql").replace("schema_eloarquivo", nomeSchemaEloArquivo);
        List recursos = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RecursoLicitacaoDTO.class));
        for (RecursoLicitacaoDTO recurso : recursos) {
            MapSqlParameterSource paramsWhere = new MapSqlParameterSource();
            paramsWhere.addValue("idchave", (Object)String.format("R%s", recurso.getId()), 12);
            recurso.getArquivos().addAll(this.datasourceWrapper.getJdbcTemplate().query(sqlArquivos, (SqlParameterSource)paramsWhere, (RowMapper)new ElotechBeanPropertyRowMapper(RecursoArquivoDTO.class)));
        }
        return recursos;
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/ultimaAtualizacaoLicitacao.sql");
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }

    public List<LicitacaoParticipanteDTO> findAllByLicitacao(FindLicitacaoParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)"db/sql/compras/participantes.sql"));
        params.getLicitacao().ifPresent(numero -> query.append(" AND CL.NUMEROLICITACAO = :licitacao "));
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoParticipanteDTO.class));
    }

    public Page<LicitacaoParticipanteDTO> findByRsql(String search, Pageable pageable) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)"db/sql/compras/participantes.sql"));
        HashMap params = new HashMap();
        if (search != null && !search.isBlank()) {
            Map parsed = RsqlToJdbcParams.parse((String)search);
            LicitacaoRepositoryImpl.replaceIfPresent((Map)parsed, (String)"licitacao_entidade", (String)"entidade", (boolean)true);
            LicitacaoRepositoryImpl.replaceIfPresent((Map)parsed, (String)"licitacao_exercicio", (String)"exercicio", (boolean)true);
            LicitacaoRepositoryImpl.replaceIfPresent((Map)parsed, (String)"licitacao_numeroLicitacao", (String)"numeroLicitacao", (boolean)true);
            if (parsed.get("numeroLicitacao") != null) {
                query.append(" AND CL.LICITACAO = :numeroLicitacao ");
            }
            if (parsed.get("entidade") != null) {
                query.append(" AND PD.ENTIDADE = :entidade ");
            }
            if (parsed.get("exercicio") != null) {
                query.append(" AND PD.EXERCICIO = :exercicio ");
            }
            if (parsed.get("fornecedor_cnpjCpf") != null) {
                query.append(" AND P.CNPJ_CPF = :fornecedor_cnpjCpf ");
            }
            if (parsed.get("fornecedor_nomeFantasia") != null) {
                query.append(" AND P.NOMEFANTASIA ILIKE :fornecedor_nomeFantasia ");
            }
            if (parsed.get("fornecedor_nome") != null) {
                query.append(" AND P.NOME ILIKE :fornecedor_nome ");
            }
            parsed.replaceAll((k, v) -> {
                if (v instanceof String) {
                    Object s = (String)v;
                    if (!((String)(s = ((String)s).replace('*', '%'))).contains("%")) {
                        s = "%" + (String)s + "%";
                    }
                    return s;
                }
                return v;
            });
            params.putAll(parsed);
        }
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)"ORDER BY P.NOME");
        String paginatedSql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List participantes = this.datasourceWrapper.getJdbcTemplate().query(paginatedSql, params, (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoParticipanteDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(this.getSqlCount(queryOrder), params, Long.class);
        return new PageImpl(participantes, pageable, total.longValue());
    }

    private String getSqlCount(String sql) {
        return "SELECT COUNT(1) TOTAL FROM (" + sql + ") T";
    }

    private static void replaceIfPresent(Map<String, Object> params, String fromKey, String toKey, boolean removeOriginal) {
        if (params.containsKey(fromKey)) {
            params.putIfAbsent(toKey, params.get(fromKey));
            if (removeOriginal) {
                params.remove(fromKey);
            }
        }
    }

    public LicitacaoParticipanteDTO findAllLicitacoesByParticipante(Long participante, Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)"db/sql/compras/participanteLicitacoes.sql");
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("pessoa", participante);
        params.put("entidade", entidade);
        params.put("exercicio", exercicio);
        List results = this.datasourceWrapper.getJdbcTemplate().queryForList(sql, params);
        if (results.isEmpty()) {
            return new LicitacaoParticipanteDTO();
        }
        LicitacaoParticipanteDTO participanteDTO = this.getLicitacaoParticipanteDTO(results);
        ArrayList<LicitacaoPortalDTO> licitacoes = new ArrayList<LicitacaoPortalDTO>();
        for (Map result : results) {
            LicitacaoPortalDTO licitacaoDTO = new LicitacaoPortalDTO();
            licitacaoDTO.setModalidade((String)result.get("MODALIDADE"));
            licitacaoDTO.setLicitacao(Long.valueOf(Long.parseLong(result.get("LICITACAO").toString())));
            licitacaoDTO.setExercicio(Long.valueOf(Long.parseLong(result.get("EXERCICIO").toString())));
            Timestamp ts = (Timestamp)result.get("DATAABERTURA");
            if (ts != null) {
                licitacaoDTO.setDataAbertura(ts.toLocalDateTime().toLocalDate());
            }
            licitacoes.add(licitacaoDTO);
        }
        participanteDTO.setLicitacoes(licitacoes);
        return participanteDTO;
    }

    private LicitacaoParticipanteDTO getLicitacaoParticipanteDTO(List<Map<String, Object>> results) {
        Map<String, Object> first = results.getFirst();
        LicitacaoParticipanteDTO participanteDTO = new LicitacaoParticipanteDTO();
        participanteDTO.setRazaoSocial((String)first.get("NOME"));
        participanteDTO.setNomeFantasia((String)first.get("NOMEFANTASIA"));
        participanteDTO.setCnpj((String)first.get("CNPJ_CPF"));
        return participanteDTO;
    }
}

