/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.adm.compras.client.LicitacaoClient;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.oxy.adm.compras.client.portal.LicitacaoParticipanteDTO;
import br.com.elotech.oxy.adm.compras.client.portal.LicitacaoPortalDTO;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AtaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CertidaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoSeiDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.MidiaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ParecerDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PrecoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PublicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.protocolo.enums.OrigemProtocoloBaseEnum;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class LicitacaoOxyRepositoryImpl
implements LicitacaoRepository {
    private final LicitacaoClient client;
    private final PortalParametroService portalParametroService;

    public Page<LicitacaoDTO> findLicitacoes(FindLicitacaoParams params, Pageable pageable) {
        boolean filtraProcAdm = SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_FILTRAR_PROC_ADM_EXERCICIO_ATUAL));
        params.setIgnoraExercicioLogadoProcAdm(Boolean.valueOf(!filtraProcAdm || Boolean.TRUE.equals(params.getIgnoraExercicioLogado())));
        EloPage licitacoesPage = this.client.findAll(params.toComprasOxyParams(), pageable);
        List<LicitacaoDTO> licitacoes = licitacoesPage.getContent().stream().map(LicitacaoDTO::fromLicitacaoOxy).toList();
        return new PageImpl(licitacoes, pageable, licitacoesPage.getTotalElements());
    }

    public LicitacaoDTO findLicitacao(FindLicitacaoParams params) {
        return LicitacaoDTO.fromLicitacaoOxy((LicitacaoPortalDTO)this.client.findOne(params.toComprasOxyParams()));
    }

    public List<ParecerDTO> findPareceres(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findPareceres(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(ParecerDTO::fromParecerComprasOxy).toList();
    }

    public List<CotacaoLicitacaoDTO> findCotacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findCotacoes(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(CotacaoLicitacaoDTO::fromCotacaoComprasOxy).toList();
    }

    public List<MidiaLicitacaoDTO> findMidia(FindLicitacaoParams params) {
        return this.client.findMidia(params.toComprasOxyParams()).stream().map(MidiaLicitacaoDTO::fromMidiaComprasOxy).toList();
    }

    public List<PublicacaoLicitacaoDTO> findPublicacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findPublicacoes(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(PublicacaoLicitacaoDTO::fromPublicacaoComprasOxy).toList();
    }

    public List<AtaLicitacaoDTO> findAtasRegistroPreco(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findAtasRegistroPreco(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(AtaLicitacaoDTO::fromAtaComprasOxy).toList();
    }

    public List<AtaLicitacaoDTO> findAtasLicitacao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findAtasLicitacao(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(AtaLicitacaoDTO::fromAtaComprasOxy).toList();
    }

    public List<AtaLicitacaoDTO> findAtasSessaoPregao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        throw new NotImplementedException("TO not implemented yet.");
    }

    public List<CertidaoLicitacaoDTO> findCertidoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findCertidoes(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(CertidaoLicitacaoDTO::fromCertidaoComprasOxy).toList();
    }

    public List<PrecoLicitacaoDTO> findPrecos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findPrecos(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(PrecoLicitacaoDTO::fromPrecoComprasOxy).toList();
    }

    public List<RecursoLicitacaoDTO> findRecursos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findRecursos(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(RecursoLicitacaoDTO::fromRecursosComprasOxy).toList();
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return UltimaAtualizacaoDTO.fromUltimasAtualizacoesOxy((List)this.client.findUltimaAtualizacao(params.toComprasOxyParams()));
    }

    public List<LicitacaoSeiDTO> findSei(FindLicitacaoParams params) {
        return this.client.findProcessoAdministrativoProtocolo(params.getProcessoAdmId()).stream().filter(protocoloBaseDTO -> protocoloBaseDTO.getProtocolo() == null && protocoloBaseDTO.getOrigem() == OrigemProtocoloBaseEnum.SEI).map(LicitacaoSeiDTO::fromProcessoBaseOxy).toList();
    }

    public List<LicitacaoParticipanteDTO> findAllByLicitacao(FindLicitacaoParams params) {
        if (Objects.isNull(params.getOxyId())) {
            throw new EloValidationException("Id da licita\u00e7\u00e3o n\u00e3o informado");
        }
        return this.client.findAllByLicitacao(params.getOxyId());
    }

    public Page<LicitacaoParticipanteDTO> findByRsql(String search, Pageable pageable) {
        return this.client.findByRSQL(search, pageable);
    }

    public LicitacaoParticipanteDTO findAllLicitacoesByParticipante(Long participante, Long entidade, Long exercicio) {
        return this.client.findAllLicitacoesByParticipante(participante, entidade, exercicio);
    }

    @Generated
    public LicitacaoOxyRepositoryImpl(LicitacaoClient client, PortalParametroService portalParametroService) {
        this.client = client;
        this.portalParametroService = portalParametroService;
    }
}

