/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.repository.impl;

import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.core.exception.EloDatabaseException;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class EloArquivoCustomRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EloArquivoCustomRepository.class);
    private static final int BUFFER_SIZE = 1000000;
    protected static final String QUERY_POSTGRESQL = "select a.nome, length(ac.arquivo) as tamanho,  cast(substring(ac.arquivo      from (generate_series(1, LENGTH(ac.arquivo) / %BUFFER% + 1) - 1)*%BUFFER% + 1      for %BUFFER% ) as bytea) as arquivo from %ELOARQUIVO%.arquivo_content ac  join %ELOARQUIVO%.arquivo a on ac.id = a.id  where a.id = %ID%";
    protected static final String QUERY_ORACLE = "select a.nome, ac.arquivo, length(ac.arquivo) as tamanho  from %ELOARQUIVO%.ARQUIVO a  join %ELOARQUIVO%.ARQUIVO_CONTENT ac on a.id = ac.id  where a.id = %ID%";
    private static final String ARQUIVO = "arquivo";
    private final DatasourceWrapper datasourceWrapper;
    private final String schemaEloArquivo;
    private final Environment environment;

    public EloArquivoCustomRepository(DatasourceWrapper datasourceWrapper, @Value(value="${db.eloarquivo.schema:eloarquivo}") String schemaEloarquivo, Environment environment) {
        this.datasourceWrapper = datasourceWrapper;
        this.schemaEloArquivo = schemaEloarquivo;
        this.environment = environment;
    }

    protected String getDownloadQuery() {
        String platform = this.datasourceWrapper.getPlatform();
        if (this.environment.matchesProfiles(new String[]{"cloud"}) || SqlUtils.isPostgres((String)platform)) {
            return QUERY_POSTGRESQL;
        }
        if (SqlUtils.isOracle((String)platform) || SqlUtils.isH2((String)platform)) {
            return QUERY_ORACLE;
        }
        throw new EloDatabaseException("Plataforma de banco de dados n\u00e3o suportada: ".concat(platform), null);
    }

    public void downloadArquivo(HttpServletResponse response, Long id) {
        log.debug("Criando nova conex\u00e3o para download do arquivo {}", (Object)id);
        try (Connection connection = this.datasourceWrapper.getDataSource().getConnection();){
            connection.setAutoCommit(false);
            connection.setReadOnly(true);
            try (Statement stmt = connection.createStatement(1003, 1007);){
                stmt.setFetchSize(1);
                stmt.setFetchDirection(1000);
                String query = this.getDownloadQuery().replace("%BUFFER%", String.valueOf(1000000)).replace("%ELOARQUIVO%", this.schemaEloArquivo).replace("%ID%", String.valueOf(id));
                log.debug("Iniciando download do arquivo {}", (Object)id);
                try (ResultSet rs = stmt.executeQuery(query);){
                    this.handleResults(response, rs);
                }
            }
        }
        catch (Exception e) {
            log.error("Erro ao realizar download do arquivo {}", (Object)id, (Object)e);
            throw e;
        }
    }

    private void handleResults(HttpServletResponse response, ResultSet result) {
        result.next();
        if (!result.isFirst()) {
            throw new EloDatabaseException("Arquivo n\u00e3o encontrado", null);
        }
        response.setHeader("Content-Disposition", "inline; filename=\"" + result.getString("nome") + "\"");
        response.setContentLengthLong(result.getLong("tamanho"));
        response.setContentType(ContentType.fromExtension((String)result.getString("nome")).getType());
        do {
            result.getBinaryStream(ARQUIVO).transferTo((OutputStream)response.getOutputStream());
        } while (result.next());
    }
}

