/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.ws.service.impl;

import br.com.elotech.ServicoExternoAuditoriaWrapper;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.HorasExtrasDetalhesDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ProcessoDisciplinarDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.RegistroPontoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosFinanceirosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidoresHorasExtrasDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.DadosFinanceiros;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetHorasExtrasDetalhesEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetHorasExtrasDetalhesParam;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetHorasExtrasDetalhesResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetPermutasEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetProcessoAdministrativoEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetProcessoAdministrativoParam;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetProcessoAdministrativoResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresCedidosEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresCedidosResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresCedidosRespostaResult;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresDadosFinanceirosEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresDadosFinanceirosParam;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresDadosFinanceirosResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresDadosFinanceirosRespostaResult;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresHoraExtraEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresHoraExtraResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresHoraExtraRespostaResult;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresParam;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresRegistroPontoEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresRegistroPontoParam;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresRegistroPontoResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresRegistroPontoRespostaResult;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresVencimentosEDescontosEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresVencimentosEDescontosParam;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresVencimentosEDescontosResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresVencimentosEDescontosRespostaResult;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.HorasExtrasDetalhes;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.Processos;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.RegistroPontoDias;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.SecretariaHoraExtra;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.VencimentosEDescontos;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.interfaces.ServidoresResponse;
import br.com.elotech.portaltransparencia.aiseportal.ws.service.ServidorServiceWS;
import br.com.elotech.portaltransparencia.aiseportal.ws.service.impl.SeniorWSService;
import br.com.elotech.portaltransparencia.utils.AuditoriaUtils;
import br.com.elotech.portaltransparencia.web.rest.params.HorasExtrasDetalhesParams;
import br.com.elotech.portaltransparencia.web.rest.params.ProcessoAdministrativoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorCedidoDataParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorCedidoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
public class ServidorServiceWSImpl
implements ServidorServiceWS {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServidorServiceWSImpl.class);
    private static final int DESCONTO = 2;
    private static final int VENCIMENTO = 1;
    private static final String TIPO_VENCIMENTO = "P";
    private static final String ENTIDADE_ESTAGIARIOS_PREFEITURA_MARINGA = "2";
    private final WebServiceTemplate webServiceTemplate;
    private final SeniorWSService seniorWSService;
    private final ServicoExternoAuditoriaWrapper auditoriaWrapper;
    @Value(value="${elotech.servidor.senior.entidadesSenior:}")
    private String entidadesSenior;
    @Value(value="${elotech.servidor.senior.entidadesElotech:}")
    private String entidadesElotech;
    @Value(value="${elotech.servidor.senior.baseUrl:}")
    private String seniorWebServiceUrl;

    public ServidorServiceWSImpl(WebServiceTemplate webServiceTemplate, SeniorWSService seniorWSService, ServicoExternoAuditoriaWrapper auditoriaWrapper) {
        this.webServiceTemplate = webServiceTemplate;
        this.seniorWSService = seniorWSService;
        this.auditoriaWrapper = auditoriaWrapper;
    }

    public List<ServidorDTO> getServidores(ServidorParams params) {
        GetServidoresParam parameters = GetServidoresParam.builder().ano(Integer.valueOf(params.getExercicio().intValue())).empresa(this.eloEntityToSenior(params.getEntidade())).build();
        GetServidoresEnvio servidoresEnvio = new GetServidoresEnvio(parameters);
        return this.getServidoresWS(servidoresEnvio, new ArrayList());
    }

    public List<ServidorDTO> getServidoresWS(GetServidoresEnvio envio, List<ServidorDTO> oldValue) {
        return this.seniorWSService.getServidoresWS(envio);
    }

    public ServidorDTO getServidorDadosFinanceirosWS(ServidorDTO servidorDTO) {
        GetServidoresDadosFinanceirosParam parameters = new GetServidoresDadosFinanceirosParam();
        if (Objects.nonNull(servidorDTO) && Objects.nonNull(servidorDTO.getExercicio()) && Objects.nonNull(servidorDTO.getMatricula())) {
            parameters.setAno(Integer.valueOf(servidorDTO.getExercicio().intValue()));
            parameters.setMatricula(Integer.valueOf(servidorDTO.getMatricula().intValue()));
        }
        GetServidoresDadosFinanceirosEnvio envio = new GetServidoresDadosFinanceirosEnvio(parameters);
        return this.getDadosFinanceirosServidor(servidorDTO, envio);
    }

    private ServidorDTO getDadosFinanceirosServidor(ServidorDTO servidorDTO, GetServidoresDadosFinanceirosEnvio envio) {
        ServidorDTO servidor = new ServidorDTO();
        GetServidoresDadosFinanceirosResposta resposta = (GetServidoresDadosFinanceirosResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getDadosFinanceirosServidor", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST), () -> (GetServidoresDadosFinanceirosResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
        if (this.hasResult((ServidoresResponse)resposta).booleanValue()) {
            GetServidoresDadosFinanceirosRespostaResult dadosFinanceirosResposta = resposta.getResult();
            servidor = this.mountServidorDTO(servidorDTO, dadosFinanceirosResposta);
        }
        return servidor;
    }

    private ServidorDTO mountServidorDTO(ServidorDTO servidorDTO, GetServidoresDadosFinanceirosRespostaResult dadosFinanceirosResposta) {
        LocalDate date;
        ArrayList<ServidorDadosFinanceirosDTO> dadosFinanceiros = new ArrayList<ServidorDadosFinanceirosDTO>();
        servidorDTO.setLocalTrabalho(dadosFinanceirosResposta.getLocalTrabalho());
        servidorDTO.setCedido(dadosFinanceirosResposta.getCedidoDe());
        servidorDTO.setCedidoPara(dadosFinanceirosResposta.getCedidoPara());
        servidorDTO.setDescricaoLotacao(dadosFinanceirosResposta.getLotacao());
        if (StringUtils.isNotBlank((String)dadosFinanceirosResposta.getDataDemissao())) {
            date = LocalDate.parse(dadosFinanceirosResposta.getDataDemissao(), DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            servidorDTO.setDataDemissao(date);
        }
        if (StringUtils.isNotBlank((String)dadosFinanceirosResposta.getDataAdmissao())) {
            date = LocalDate.parse(dadosFinanceirosResposta.getDataAdmissao(), DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            servidorDTO.setDataAdmissao(date);
        }
        if (StringUtils.isNotBlank((String)dadosFinanceirosResposta.getDataTransposicao())) {
            date = LocalDate.parse(dadosFinanceirosResposta.getDataTransposicao(), DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            servidorDTO.setDataTransposicao(date);
        }
        if (StringUtils.isNotBlank((String)dadosFinanceirosResposta.getHorarioTrabalho())) {
            servidorDTO.setHorarioTrabalho(dadosFinanceirosResposta.getHorarioTrabalho());
        }
        servidorDTO.setHorasSemanais(Objects.nonNull(dadosFinanceirosResposta.getHorasSemanais()) ? BigDecimal.valueOf(dadosFinanceirosResposta.getHorasSemanais().intValue()) : BigDecimal.ZERO);
        if (Objects.nonNull(dadosFinanceirosResposta.getDadosFinanceiros())) {
            for (DadosFinanceiros dadoFinanceiroItem : dadosFinanceirosResposta.getDadosFinanceiros()) {
                ServidorDadosFinanceirosDTO dadoFinanceiro = this.mountDadosFinanceirosDTO(servidorDTO, dadoFinanceiroItem);
                servidorDTO.setSalarioBase(Objects.nonNull(dadoFinanceiroItem.getSalarioCargo()) ? BigDecimal.valueOf(dadoFinanceiroItem.getSalarioCargo()) : BigDecimal.ZERO);
                dadosFinanceiros.add(dadoFinanceiro);
            }
        }
        servidorDTO.setDadosFinanceiros(dadosFinanceiros);
        return servidorDTO;
    }

    private ServidorDadosFinanceirosDTO mountDadosFinanceirosDTO(ServidorDTO servidorDTO, DadosFinanceiros financeiro) {
        ServidorDadosFinanceirosDTO dadoFinanceiro = new ServidorDadosFinanceirosDTO();
        dadoFinanceiro.setEntidade(servidorDTO.getEntidade());
        dadoFinanceiro.setMatricula(servidorDTO.getMatricula());
        dadoFinanceiro.setAnoCompetencia(servidorDTO.getExercicio());
        if (Objects.nonNull(financeiro)) {
            this.setDadosFinanceirosIfExists(dadoFinanceiro, financeiro);
        }
        return dadoFinanceiro;
    }

    private void setDadosFinanceirosIfExists(ServidorDadosFinanceirosDTO servidorDadosFinanceiros, DadosFinanceiros dados) {
        if (Objects.nonNull(dados.getCodigoCalculo())) {
            servidorDadosFinanceiros.setCodigoCalculo(Long.valueOf(dados.getCodigoCalculo().longValue()));
        }
        if (Objects.nonNull(dados.getTipoFolha())) {
            servidorDadosFinanceiros.setDescricaoTipoFolha(dados.getTipoFolha());
        }
        if (Objects.nonNull(dados.getMesCompetencia())) {
            servidorDadosFinanceiros.setMesCompetencia(Long.valueOf(dados.getMesCompetencia().longValue()));
        }
        servidorDadosFinanceiros.setVencimentos(Objects.nonNull(dados.getProventos()) ? BigDecimal.valueOf(dados.getProventos()) : BigDecimal.ZERO);
        servidorDadosFinanceiros.setDescontos(Objects.nonNull(dados.getDescontos()) ? BigDecimal.valueOf(dados.getDescontos()) : BigDecimal.ZERO);
        servidorDadosFinanceiros.setSalarioBase(Objects.nonNull(dados.getSalarioCargo()) ? BigDecimal.valueOf(dados.getSalarioCargo()) : BigDecimal.ZERO);
    }

    public List<ServidorVencimentosDescontosDTO> getVencimentoEDescontosWS(ServidorParams params) {
        GetServidoresVencimentosEDescontosEnvio envio = this.mountVencimentoEDescontosEnvio(params);
        return this.getVencimentosEDescontosServidor(envio);
    }

    private GetServidoresVencimentosEDescontosEnvio mountVencimentoEDescontosEnvio(ServidorParams params) {
        GetServidoresVencimentosEDescontosParam parameters = new GetServidoresVencimentosEDescontosParam();
        parameters.setAno(Integer.valueOf(params.getAnoCompetencia().intValue()));
        parameters.setMes(Integer.valueOf(params.getMesCompetencia().intValue()));
        parameters.setMatricula(Integer.valueOf(params.getMatricula().intValue()));
        parameters.setCodigoCalculo(Integer.valueOf(params.getCodigoCalculo().intValue()));
        if (params.getTipoEvento().equalsIgnoreCase(TIPO_VENCIMENTO)) {
            parameters.setTipoConsulta(Integer.valueOf(1));
        } else {
            parameters.setTipoConsulta(Integer.valueOf(2));
        }
        return new GetServidoresVencimentosEDescontosEnvio(parameters);
    }

    private List<ServidorVencimentosDescontosDTO> getVencimentosEDescontosServidor(GetServidoresVencimentosEDescontosEnvio envio) {
        GetServidoresVencimentosEDescontosResposta resposta = (GetServidoresVencimentosEDescontosResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getVencimentosEDescontosServidor", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST), () -> (GetServidoresVencimentosEDescontosResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
        ArrayList<ServidorVencimentosDescontosDTO> listaVencimentosEDescontos = new ArrayList<ServidorVencimentosDescontosDTO>();
        if (this.hasResult((ServidoresResponse)resposta).booleanValue() && Objects.nonNull(resposta.getResult().getEventos())) {
            GetServidoresVencimentosEDescontosRespostaResult vencimentosEDescontosResult = resposta.getResult();
            for (VencimentosEDescontos vd : vencimentosEDescontosResult.getEventos()) {
                ServidorVencimentosDescontosDTO dto = new ServidorVencimentosDescontosDTO();
                dto.setDescricao(vd.getDescricao());
                dto.setValor(new BigDecimal(vd.getValor()));
                listaVencimentosEDescontos.add(dto);
            }
        }
        return listaVencimentosEDescontos;
    }

    public List<RegistroPontoDTO> getRegistroPontoWS(ServidorParams params) {
        GetServidoresRegistroPontoEnvio envio = this.mountRegistroPontoEnvio(params);
        return this.getRegistroPontoServidor(envio);
    }

    private GetServidoresRegistroPontoEnvio mountRegistroPontoEnvio(ServidorParams params) {
        GetServidoresRegistroPontoParam parameters = new GetServidoresRegistroPontoParam();
        parameters.setAno(Integer.valueOf(params.getAnoCompetencia().intValue()));
        parameters.setMes(Integer.valueOf(params.getMesCompetencia().intValue()));
        parameters.setMatricula(Integer.valueOf(params.getMatricula().intValue()));
        return new GetServidoresRegistroPontoEnvio(parameters);
    }

    private List<RegistroPontoDTO> getRegistroPontoServidor(GetServidoresRegistroPontoEnvio envio) {
        GetServidoresRegistroPontoResposta resposta = (GetServidoresRegistroPontoResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getRegistroPontoServidor", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST), () -> (GetServidoresRegistroPontoResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
        ArrayList<RegistroPontoDTO> listaRegistroPonto = new ArrayList<RegistroPontoDTO>();
        if (this.hasResult((ServidoresResponse)resposta).booleanValue() && Objects.nonNull(resposta.getResult().getDias())) {
            GetServidoresRegistroPontoRespostaResult registroPontoResult = resposta.getResult();
            for (RegistroPontoDias ponto : registroPontoResult.getDias()) {
                RegistroPontoDTO dto = new RegistroPontoDTO();
                dto.setExercicio(Long.valueOf(envio.getParameters().getAno().intValue()));
                dto.setMes(Long.valueOf(envio.getParameters().getMes().intValue()));
                dto.setMatricula(Long.valueOf(envio.getParameters().getMatricula().intValue()));
                dto.setData(ponto.getData());
                dto.setDiaSemana(ponto.getDiaSemana());
                dto.setObservacao(ponto.getObservacao());
                dto.setRegistros(ponto.getRegistros());
                listaRegistroPonto.add(dto);
            }
        }
        return listaRegistroPonto;
    }

    public Optional<ServidorDTO> loadServidorComDadosFinanceiros(ServidorParams params) {
        ServidorDTO servidorFound = this.findServidor(params);
        if (Objects.isNull(servidorFound)) {
            servidorFound = this.findEstagiario(params);
        }
        if (servidorFound != null) {
            servidorFound.setExercicio(params.getExercicio());
            servidorFound.setEntidade(params.getEntidadeAise());
        }
        return Optional.of(this.getServidorDadosFinanceirosWS(servidorFound));
    }

    public Optional<ServidoresHorasExtrasDTO> getServidoresHorasExtras(ServidorParams params) {
        GetServidoresHoraExtraEnvio envio = new GetServidoresHoraExtraEnvio(params);
        GetServidoresHoraExtraResposta resposta = (GetServidoresHoraExtraResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)params, (String)"getServidoresHorasExtras", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST), () -> (GetServidoresHoraExtraResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
        ServidoresHorasExtrasDTO horasExtras = new ServidoresHorasExtrasDTO();
        ArrayList<SecretariaHoraExtra> secretarias = new ArrayList<SecretariaHoraExtra>();
        if (this.hasResult((ServidoresResponse)resposta).booleanValue()) {
            GetServidoresHoraExtraRespostaResult horaExtraResult = resposta.getResult();
            for (SecretariaHoraExtra sec : horaExtraResult.getSecretarias()) {
                secretarias.add(SecretariaHoraExtra.builder().secretaria(sec.getSecretaria()).horasExtras(sec.getHorasExtras()).valorPago(sec.getValorPago()).build());
                horasExtras.sumHoras(sec.getHorasExtras());
                horasExtras.sumValor(sec.getValorPago());
            }
            horasExtras.setSecretarias(secretarias);
        }
        return Optional.of(horasExtras);
    }

    private ServidorDTO findServidor(ServidorParams params) {
        return this.getServidores(params).stream().filter(servidor -> servidor.getMatricula().equals(params.getMatricula())).findFirst().orElse(null);
    }

    private ServidorDTO findEstagiario(ServidorParams params) {
        EstagiarioDTO estagiarioDTO = this.getEstagiarios(params).stream().filter(estagiario -> estagiario.getMatricula().equals(params.getMatricula())).findFirst().orElse(null);
        if (Objects.nonNull(estagiarioDTO)) {
            return ServidorDTOConverter.EstagiarioDTOToServidorDTO((EstagiarioDTO)estagiarioDTO);
        }
        return null;
    }

    private String eloEntityToSenior(Long entidade) {
        if (Objects.isNull(entidade) || this.entidadesSenior.length() == 0 || this.entidadesElotech.length() == 0) {
            return null;
        }
        String[] senior = this.entidadesSenior.split(",");
        String[] elo = this.entidadesElotech.split(",");
        try {
            int index = 0;
            for (String e : elo) {
                if (entidade.toString().equals(e.trim())) break;
                ++index;
            }
            return senior[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private <T> Boolean hasResult(ServidoresResponse<T> resposta) {
        return Objects.nonNull(resposta) && Objects.nonNull(resposta.getResult());
    }

    public List<PermutaDTO> getPermutasWS(GetPermutasEnvio envio, List<PermutaDTO> oldValue) {
        return this.seniorWSService.getPermutasWS(envio);
    }

    public List<PermutaDTO> getPermutas() {
        GetServidoresParam parameters = new GetServidoresParam();
        GetPermutasEnvio getPermutasEnvio = new GetPermutasEnvio(parameters);
        return this.getPermutasWS(getPermutasEnvio, new ArrayList());
    }

    public List<HorasExtrasDetalhesDTO> getHorasExtrasDetalhesWS(GetHorasExtrasDetalhesEnvio envio) {
        LOGGER.info("Carregando Horas Extras do WebService de Maring\u00e1");
        LOGGER.info("Esse procedimento pode demorar ...");
        GetHorasExtrasDetalhesResposta resposta = null;
        try {
            resposta = (GetHorasExtrasDetalhesResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getHorasExtrasDetalhesWS", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST), () -> (GetHorasExtrasDetalhesResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
            LOGGER.info(" carregadas com sucesso!");
        }
        catch (Exception e) {
            LOGGER.error("Erro ao carregar os detalhes das horas extras.", (Object)e.getMessage(), (Object)e);
        }
        if (this.hasResult(resposta).booleanValue() && Objects.nonNull(resposta.getResult().getServidores())) {
            return resposta.getResult().getServidores().stream().map(horasExtrasDetalhes -> this.horasExtrasToHorasExtrasDetalhesDTO(horasExtrasDetalhes)).collect(Collectors.toList());
        }
        return new ArrayList<HorasExtrasDetalhesDTO>();
    }

    private HorasExtrasDetalhesDTO horasExtrasToHorasExtrasDetalhesDTO(HorasExtrasDetalhes horasExtrasDetalhes) {
        return HorasExtrasDetalhesDTO.builder().matricula(horasExtrasDetalhes.getMatricula()).nome(horasExtrasDetalhes.getNome()).horasExtras(horasExtrasDetalhes.getHorasExtras()).valorPago(horasExtrasDetalhes.getValorPago()).build();
    }

    public List<HorasExtrasDetalhesDTO> getHorasExtrasDetalhes(HorasExtrasDetalhesParams horasExtrasDetalhes) {
        GetHorasExtrasDetalhesEnvio envio = new GetHorasExtrasDetalhesEnvio();
        envio.setParameters(GetHorasExtrasDetalhesParam.builder().ano(Integer.valueOf(horasExtrasDetalhes.getAnoCompetencia().intValue())).mes(horasExtrasDetalhes.getMesCompetencia()).secretaria(horasExtrasDetalhes.getSecretaria()).build());
        ArrayList<HorasExtrasDetalhesDTO> listaHorasExtrasDetalhes = new ArrayList();
        listaHorasExtrasDetalhes = this.getHorasExtrasDetalhesWS(envio);
        return listaHorasExtrasDetalhes;
    }

    private ProcessoDisciplinarDTO processosToProcessoDisciplinarDTO(Processos processo) {
        return ProcessoDisciplinarDTO.builder().numeroProcesso(processo.getNumeroProcesso()).dataAbertura(processo.getDataAbertura()).assunto(processo.getAssunto()).andamento(processo.getAndamento()).build();
    }

    public List<ProcessoDisciplinarDTO> getProcessosAdministrativos(ProcessoAdministrativoParams params) {
        LOGGER.info("Carregando Processos Administrativos do WebService de Maring\u00e1");
        LOGGER.info("Esse procedimento pode demorar ...");
        GetProcessoAdministrativoEnvio envio = new GetProcessoAdministrativoEnvio();
        GetProcessoAdministrativoResposta resposta = null;
        envio.setParameters(GetProcessoAdministrativoParam.builder().dataInicio(params.getDataInicio()).dataFim(params.getDataFim()).build());
        try {
            resposta = (GetProcessoAdministrativoResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getProcessosAdministrativos", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST), () -> (GetProcessoAdministrativoResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
            LOGGER.info("Processos Administrativos carregadas com sucesso!");
        }
        catch (Exception e) {
            LOGGER.error("Erro ao carregar os processos administrativos.", (Object)e.getMessage(), (Object)e);
        }
        if (this.hasResult(resposta).booleanValue() && Objects.nonNull(resposta.getResult().getProcessos())) {
            return resposta.getResult().getProcessos().stream().map(processos -> this.processosToProcessoDisciplinarDTO(processos)).collect(Collectors.toList());
        }
        return new ArrayList<ProcessoDisciplinarDTO>();
    }

    public List<EstagiarioDTO> getEstagiariosWS(GetServidoresEnvio envio, List<EstagiarioDTO> oldValue) {
        return this.seniorWSService.getEstagiariosWS(envio);
    }

    public List<EstagiarioDTO> getEstagiarios(ServidorParams params) {
        GetServidoresParam parameters = GetServidoresParam.builder().ano(Integer.valueOf(params.getExercicio().intValue())).empresa(ENTIDADE_ESTAGIARIOS_PREFEITURA_MARINGA).build();
        return this.getEstagiariosWS(new GetServidoresEnvio(parameters), new ArrayList());
    }

    public GetServidoresCedidosRespostaResult getServidoresCedidos(ServidorCedidoParams params) {
        LOGGER.info("Carregando servidores cedidos do WebService de Maring\u00e1");
        try {
            GetServidoresCedidosEnvio envio = new GetServidoresCedidosEnvio(new ServidorCedidoDataParams());
            GetServidoresCedidosResposta resposta = (GetServidoresCedidosResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getServidoresCedidos", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST), () -> (GetServidoresCedidosResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
            GetServidoresCedidosRespostaResult respostaFiltro = resposta.getResult();
            if (Objects.nonNull(params.getMatricula())) {
                respostaFiltro.setServidores(respostaFiltro.getServidores().stream().filter(s -> Objects.equals(s.getMatricula(), Integer.valueOf(params.getMatricula()))).collect(Collectors.toList()));
            }
            if (Objects.nonNull(params.getNome())) {
                respostaFiltro.setServidores(respostaFiltro.getServidores().stream().filter(s -> s.getNome().contains(params.getNome().toUpperCase())).collect(Collectors.toList()));
            }
            if (Objects.nonNull(params.getTipo())) {
                respostaFiltro.setServidores(respostaFiltro.getServidores().stream().filter(s -> Objects.equals(s.getTipo(), params.getTipo().toUpperCase())).collect(Collectors.toList()));
            }
            if (Objects.nonNull(params.getOrgaoDestino())) {
                respostaFiltro.setServidores(respostaFiltro.getServidores().stream().filter(s -> s.getOrgaoDestino().toUpperCase().contains(params.getOrgaoDestino().toUpperCase())).collect(Collectors.toList()));
            }
            LOGGER.info("Servidores cedidos carregados com sucesso!");
            return respostaFiltro;
        }
        catch (Exception e) {
            LOGGER.error("Erro ao carregar servidores cedidos: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

