/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.ws.service.impl;

import br.com.elotech.ServicoExternoAuditoriaWrapper;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.EstagiarioDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.function.ServidorWsToDTO;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetPermutasEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetPermutasResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresEnvio;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresResposta;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.Permutas;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.interfaces.ServidoresResponse;
import br.com.elotech.portaltransparencia.utils.AuditoriaUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;

@Service
public class SeniorWSService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SeniorWSService.class);
    private final WebServiceTemplate webServiceTemplate;
    private final ServicoExternoAuditoriaWrapper auditoriaWrapper;
    @Value(value="${elotech.servidor.senior.baseUrl:}")
    private String seniorWebServiceUrl;

    public SeniorWSService(WebServiceTemplate webServiceTemplate, ServicoExternoAuditoriaWrapper auditoriaWrapper) {
        this.webServiceTemplate = webServiceTemplate;
        this.auditoriaWrapper = auditoriaWrapper;
    }

    @Cacheable(cacheNames={"servidores_webservice"}, keyGenerator="tenantCacheKeyGenerator")
    public List<ServidorDTO> getServidoresWS(GetServidoresEnvio envio) {
        GetServidoresResposta resposta;
        log.info("Carregando Servidores do WebService de Maring\u00e1");
        log.info("Esse procedimento pode demorar ...");
        try {
            resposta = (GetServidoresResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getServidoresWS", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST, (boolean)false), () -> (GetServidoresResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
            log.info("Servidores carregados com sucesso!");
        }
        catch (Exception e) {
            log.error("Erro ao carregar servidores: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Erro ao carregar servidores do WebService", e);
        }
        if (this.hasResult((ServidoresResponse)resposta).booleanValue() && Objects.nonNull(resposta.getResult().getServidores())) {
            return resposta.getResult().getServidores().stream().map(new ServidorWsToDTO()).collect(Collectors.toList());
        }
        return new ArrayList<ServidorDTO>();
    }

    @Cacheable(cacheNames={"permutas_webservice"}, keyGenerator="tenantCacheKeyGenerator")
    public List<PermutaDTO> getPermutasWS(GetPermutasEnvio envio) {
        GetPermutasResposta resposta;
        log.info("Carregando Permutas do WebService de Maring\u00e1");
        log.info("Esse procedimento pode demorar ...");
        try {
            resposta = (GetPermutasResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getPermutasWS", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST, (boolean)false), () -> (GetPermutasResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
            log.info("Permutas carregadas com sucesso!");
        }
        catch (Exception e) {
            log.error("Erro ao carregar Permutas: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Erro ao carregar permutas do WebService", e);
        }
        if (this.hasResult((ServidoresResponse)resposta).booleanValue() && Objects.nonNull(resposta.getResult().getSolicitacoes())) {
            return resposta.getResult().getSolicitacoes().stream().map(arg_0 -> this.solicitacaoToPermutaDTO(arg_0)).collect(Collectors.toList());
        }
        return new ArrayList<PermutaDTO>();
    }

    @Cacheable(cacheNames={"estagiarios_webservice"}, keyGenerator="tenantCacheKeyGenerator")
    public List<EstagiarioDTO> getEstagiariosWS(GetServidoresEnvio envio) {
        log.info("Carregando Estagi\u00e1rios do WebService de Maring\u00e1");
        log.info("Esse procedimento pode demorar ...");
        GetServidoresResposta resposta = null;
        try {
            resposta = (GetServidoresResposta)this.auditoriaWrapper.executarComAuditoria(AuditoriaUtils.createAuditoriaConfig((Object)envio.getParameters(), (String)"getEstagiariosWS", (String)this.seniorWebServiceUrl, (HttpMethod)HttpMethod.POST, (boolean)false), () -> (GetServidoresResposta)this.webServiceTemplate.marshalSendAndReceive((Object)envio));
            log.info("Estagi\u00e1rios carregados com sucesso!");
        }
        catch (Exception e) {
            log.error("Erro ao carregar estagi\u00e1rios: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Erro ao carregar estagi\u00e1rios do WebService", e);
        }
        if (this.hasResult((ServidoresResponse)resposta).booleanValue() && Objects.nonNull(resposta.getResult().getServidores())) {
            List estagiarios = resposta.getResult().getServidores().stream().map(new ServidorWsToDTO()).toList();
            return estagiarios.stream().map(EstagiarioDTOConverter::ServidorDTOToEstagiarioDTO).collect(Collectors.toList());
        }
        return new ArrayList<EstagiarioDTO>();
    }

    private PermutaDTO solicitacaoToPermutaDTO(Permutas solicitacao) {
        LocalDate date = LocalDate.parse(solicitacao.getDataSolicitacao(), DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        return PermutaDTO.builder().protocolo(solicitacao.getProtocolo()).matricula(solicitacao.getMatricula()).nome(solicitacao.getNome()).lotacaoAtual(solicitacao.getLotacaoAtual()).lotacaoDesejada(solicitacao.getLotacaoDesejada()).dataSolicitacao(date).cargo(solicitacao.getCargo()).build();
    }

    private <T> Boolean hasResult(ServidoresResponse<T> resposta) {
        return Objects.nonNull(resposta) && Objects.nonNull(resposta.getResult());
    }
}

