/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.AutonomoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.AutonomoService;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoAiseOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.folhaportal.service.AutonomoServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class AutonomoServiceImpl
implements AutonomoService {
    private final AutonomoRepository autonomoRepository;
    private final PortalParametroService portalParametroService;
    private final IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService;
    private final AutonomoServiceOxy oxyService;
    private final EntidadeAiseService entidadeAiseService;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final BaseExport baseExport;
    private static final String headerFields = "Nome,Matr\u00edcula,Atividade,Lota\u00e7\u00e3o,In\u00edcio Contrato, Fim Contrato";
    private static final String fields = "nome,matricula,descricaoAtividades,descricaoLotacao,dataAdmissao,dataFimContrato";

    public Page<ServidorDTO> loadAutonomos(ServidorParams params, Pageable pageable) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
            return this.oxyService.loadAutonomos(params, pageable);
        }
        return this.autonomoRepository.loadAutonomos(params, pageable);
    }

    public Optional<ServidorDTO> loadAutonomo(ServidorParams params) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
            return this.oxyService.loadAutonomo(params);
        }
        Optional autonomo = this.autonomoRepository.loadAutonomo(params);
        autonomo.ifPresent(e -> e.setDadosFinanceiros(this.autonomoRepository.loadDadosFinanceiros(params)));
        return autonomo;
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        return new ArrayList<ServidorVencimentosDescontosDTO>();
    }

    public String findNomeEntidadeById(Long entidadeId) {
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)entidadeId);
        return Objects.nonNull(entidade) ? entidade.getNome() : "";
    }

    public String headerFields() {
        return headerFields;
    }

    public String fields() {
        return fields;
    }

    public float[] fieldsPerc() {
        return new float[]{1.5f, 0.9f, 1.5f, 1.5f, 0.9f, 0.9f};
    }

    public int[] fieldTab() {
        return new int[]{100, 20, 100, 100, 50, 50};
    }

    @Generated
    public AutonomoServiceImpl(AutonomoRepository autonomoRepository, PortalParametroService portalParametroService, IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService, AutonomoServiceOxy oxyService, EntidadeAiseService entidadeAiseService, EntidadeContabilidadeRepository entidadeRepository, BaseExport baseExport) {
        this.autonomoRepository = autonomoRepository;
        this.portalParametroService = portalParametroService;
        this.integracaoAiseOxyService = integracaoAiseOxyService;
        this.oxyService = oxyService;
        this.entidadeAiseService = entidadeAiseService;
        this.entidadeRepository = entidadeRepository;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

