/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource.params;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindDividaAtivaParams;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindDividaAtivaParams {
    private Long entidadeContabil;
    private Boolean somenteAjuizado;
    private String nome;
    private String nomeFiltro;
    private Boolean showValor;
    private Boolean showCpfCnpjCompleto;
    private Boolean showNomeCompleto;
    private Long exercicio;
    private String idContribuinte;
    private String exportType;
    private String tenant = TenantContextHolder.getTenantId().orElse(null);

    public Boolean getSomenteAjuizado() {
        return Optional.ofNullable(this.somenteAjuizado).orElse(Boolean.FALSE);
    }

    public Optional<String> getNome() {
        return Optional.ofNullable(this.nome);
    }

    public Optional<String> getNomeFiltro() {
        return Optional.ofNullable(this.nomeFiltro);
    }

    public List<Long> getIdsContribuintesList() {
        if (this.idContribuinte == null || this.idContribuinte.isBlank()) {
            return List.of();
        }
        return Arrays.stream(this.idContribuinte.split(",")).map(String::trim).filter(string -> !string.isEmpty()).map(Long::parseLong).toList();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addIdContribunte(params);
        this.addNome(params);
        this.addNomeFiltro(params);
        return params;
    }

    private void addNomeFiltro(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nomeFiltro)) {
            params.addValue("nomeFiltro", (Object)("%" + this.nomeFiltro + "%"), 12);
        }
    }

    private void addNome(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nome)) {
            params.addValue("nome", (Object)this.nome, 12);
        }
    }

    private void addIdContribunte(MapSqlParameterSource params) {
        List ids = this.getIdsContribuintesList();
        if (!ids.isEmpty()) {
            params.addValue("idContribuinte", (Object)ids);
        }
    }

    @Generated
    public static FindDividaAtivaParamsBuilder builder() {
        return new FindDividaAtivaParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindDividaAtivaParams(entidadeContabil=" + this.getEntidadeContabil() + ", somenteAjuizado=" + this.getSomenteAjuizado() + ", nome=" + String.valueOf(this.getNome()) + ", nomeFiltro=" + String.valueOf(this.getNomeFiltro()) + ", showValor=" + this.getShowValor() + ", showCpfCnpjCompleto=" + this.getShowCpfCnpjCompleto() + ", showNomeCompleto=" + this.getShowNomeCompleto() + ", exercicio=" + this.getExercicio() + ", idContribuinte=" + this.getIdContribuinte() + ", exportType=" + this.getExportType() + ", tenant=" + this.getTenant() + ")";
    }

    @Generated
    public FindDividaAtivaParams() {
    }

    @Generated
    public FindDividaAtivaParams(Long entidadeContabil, Boolean somenteAjuizado, String nome, String nomeFiltro, Boolean showValor, Boolean showCpfCnpjCompleto, Boolean showNomeCompleto, Long exercicio, String idContribuinte, String exportType, String tenant) {
        this.entidadeContabil = entidadeContabil;
        this.somenteAjuizado = somenteAjuizado;
        this.nome = nome;
        this.nomeFiltro = nomeFiltro;
        this.showValor = showValor;
        this.showCpfCnpjCompleto = showCpfCnpjCompleto;
        this.showNomeCompleto = showNomeCompleto;
        this.exercicio = exercicio;
        this.idContribuinte = idContribuinte;
        this.exportType = exportType;
        this.tenant = tenant;
    }

    @Generated
    public Long getEntidadeContabil() {
        return this.entidadeContabil;
    }

    @Generated
    public Boolean getShowValor() {
        return this.showValor;
    }

    @Generated
    public Boolean getShowCpfCnpjCompleto() {
        return this.showCpfCnpjCompleto;
    }

    @Generated
    public Boolean getShowNomeCompleto() {
        return this.showNomeCompleto;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getIdContribuinte() {
        return this.idContribuinte;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public void setEntidadeContabil(Long entidadeContabil) {
        this.entidadeContabil = entidadeContabil;
    }

    @Generated
    public void setSomenteAjuizado(Boolean somenteAjuizado) {
        this.somenteAjuizado = somenteAjuizado;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setNomeFiltro(String nomeFiltro) {
        this.nomeFiltro = nomeFiltro;
    }

    @Generated
    public void setShowValor(Boolean showValor) {
        this.showValor = showValor;
    }

    @Generated
    public void setShowCpfCnpjCompleto(Boolean showCpfCnpjCompleto) {
        this.showCpfCnpjCompleto = showCpfCnpjCompleto;
    }

    @Generated
    public void setShowNomeCompleto(Boolean showNomeCompleto) {
        this.showNomeCompleto = showNomeCompleto;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setIdContribuinte(String idContribuinte) {
        this.idContribuinte = idContribuinte;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDividaAtivaParams)) {
            return false;
        }
        FindDividaAtivaParams other = (FindDividaAtivaParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidadeContabil = this.getEntidadeContabil();
        Long other$entidadeContabil = other.getEntidadeContabil();
        if (this$entidadeContabil == null ? other$entidadeContabil != null : !((Object)this$entidadeContabil).equals(other$entidadeContabil)) {
            return false;
        }
        Boolean this$somenteAjuizado = this.getSomenteAjuizado();
        Boolean other$somenteAjuizado = other.getSomenteAjuizado();
        if (this$somenteAjuizado == null ? other$somenteAjuizado != null : !((Object)this$somenteAjuizado).equals(other$somenteAjuizado)) {
            return false;
        }
        Boolean this$showValor = this.getShowValor();
        Boolean other$showValor = other.getShowValor();
        if (this$showValor == null ? other$showValor != null : !((Object)this$showValor).equals(other$showValor)) {
            return false;
        }
        Boolean this$showCpfCnpjCompleto = this.getShowCpfCnpjCompleto();
        Boolean other$showCpfCnpjCompleto = other.getShowCpfCnpjCompleto();
        if (this$showCpfCnpjCompleto == null ? other$showCpfCnpjCompleto != null : !((Object)this$showCpfCnpjCompleto).equals(other$showCpfCnpjCompleto)) {
            return false;
        }
        Boolean this$showNomeCompleto = this.getShowNomeCompleto();
        Boolean other$showNomeCompleto = other.getShowNomeCompleto();
        if (this$showNomeCompleto == null ? other$showNomeCompleto != null : !((Object)this$showNomeCompleto).equals(other$showNomeCompleto)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Optional this$nome = this.getNome();
        Optional other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !((Object)this$nome).equals(other$nome)) {
            return false;
        }
        Optional this$nomeFiltro = this.getNomeFiltro();
        Optional other$nomeFiltro = other.getNomeFiltro();
        if (this$nomeFiltro == null ? other$nomeFiltro != null : !((Object)this$nomeFiltro).equals(other$nomeFiltro)) {
            return false;
        }
        String this$idContribuinte = this.getIdContribuinte();
        String other$idContribuinte = other.getIdContribuinte();
        if (this$idContribuinte == null ? other$idContribuinte != null : !this$idContribuinte.equals(other$idContribuinte)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindDividaAtivaParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidadeContabil = this.getEntidadeContabil();
        result = result * 59 + ($entidadeContabil == null ? 43 : ((Object)$entidadeContabil).hashCode());
        Boolean $somenteAjuizado = this.getSomenteAjuizado();
        result = result * 59 + ($somenteAjuizado == null ? 43 : ((Object)$somenteAjuizado).hashCode());
        Boolean $showValor = this.getShowValor();
        result = result * 59 + ($showValor == null ? 43 : ((Object)$showValor).hashCode());
        Boolean $showCpfCnpjCompleto = this.getShowCpfCnpjCompleto();
        result = result * 59 + ($showCpfCnpjCompleto == null ? 43 : ((Object)$showCpfCnpjCompleto).hashCode());
        Boolean $showNomeCompleto = this.getShowNomeCompleto();
        result = result * 59 + ($showNomeCompleto == null ? 43 : ((Object)$showNomeCompleto).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Optional $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : ((Object)$nome).hashCode());
        Optional $nomeFiltro = this.getNomeFiltro();
        result = result * 59 + ($nomeFiltro == null ? 43 : ((Object)$nomeFiltro).hashCode());
        String $idContribuinte = this.getIdContribuinte();
        result = result * 59 + ($idContribuinte == null ? 43 : $idContribuinte.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }
}

