/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.service.InativoService;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/inativos"})
public class InativoResource {
    private final InativoService inativoService;
    private static final Integer MAXIMO_REGISTROS_SERVIDORES = 15000;

    @Autowired
    public InativoResource(InativoService inativoService) {
        this.inativoService = inativoService;
    }

    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<ServidorDTO> getInativo(@PathVariable Long codigo, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setCodigo(codigo);
        Optional servidor = this.inativoService.loadInativo(servidorParams);
        return servidor.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping
    public ResponseEntity<Page<ServidorDTO>> loadInativos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams inativosParams, Pageable pageable) {
        inativosParams.setEntidade(entidade);
        inativosParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.inativoService.loadInativos(inativosParams, pageable));
    }

    @GetMapping(value={"/{vinculo}/{codigo}"})
    public ResponseEntity<ServidorDTO> getInativoPorVinculo(@PathVariable String vinculo, @PathVariable Long codigo, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setMatricula(codigo);
        servidorParams.setVinculo(vinculo);
        Optional servidor = this.inativoService.loadInativo(servidorParams);
        return servidor.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/vencimentos-descontos"}, params={"matricula", "anoCompetencia", "mesCompetencia", "tipoEvento", "tipoFolha", "codigoCalculo", "entidadeOrigem"})
    public ResponseEntity<List<ServidorVencimentosDescontosDTO>> loadVencimentosEDescontosInativo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidadeAise(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.inativoService.loadVencimentoEDescontos(servidorParams));
    }

    @GetMapping(value={"/report"})
    public ModelAndView loadInativosExport(HttpServletRequest request, HttpServletResponse response, @Valid ServidorParams servidorParams, Pageable pageable) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)MAXIMO_REGISTROS_SERVIDORES, (Sort)pageable.getSort());
        Page inativoPage = this.inativoService.loadInativos(servidorParams, (Pageable)page);
        return this.inativoService.exportReport(request, response, servidorParams, inativoPage);
    }
}

