/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CargoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CargoFaixaDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.CargoRepositoryCustom;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CargoRepositoryImpl
implements CargoRepositoryCustom {
    private static final Logger LOGGER = LoggerFactory.getLogger(CargoRepositoryImpl.class);
    private static final String CARGOS = "db/sql/aise/cargos.sql";
    private static final String CARGO = "db/sql/aise/cargo.sql";
    private static final String CARGOFAIXA = "db/sql/aise/cargo-vinculo-faixa.sql";
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public CargoRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<CargoFaixaDTO> findCargos(CargoParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder();
        sql.append(FileUtils.readResourceAsString((String)CARGOS));
        params.getCargo().ifPresent(item -> sql.append("\n   AND C.CARGO = :cargo "));
        params.getQuadro().ifPresent(item -> sql.append("\n   AND QS.QUADROSALARIAL = :quadro "));
        params.getGrupo().ifPresent(item -> sql.append("\n   AND GO.GRUPOOCUPACIONAL = :grupo "));
        params.getNivel().ifPresent(item -> sql.append("\n   AND GN.NIVEL = :nivel "));
        params.getDescricao().ifPresent(item -> sql.append(" AND (${db.aise.schema}.tiraacento(LOWER(C.DESCRICAO)) LIKE (${db.aise.schema}.tiraacento(LOWER(:descricao)) OR ${db.aise.schema}.tiraacento(LOWER(C.CODIGO)) LIKE ${db.aise.schema}.tiraacento(LOWER(:descricao))) "));
        sql.append("\n GROUP BY C.DESCRICAO,CL.DESCRICAO,QS.DESCRICAO,GO.DESCRICAO,GN.DESCRICAO,C.VAGAS,C.SITUACAO,CF.INICIOVALIDADE,CF.ENTIDADE,CF.CARGO,CF.QUADROSALARIAL,CF.GRUPOOCUPACIONAL,CF.NIVEL, ATO.NUMEROATO, ATO.ANOATO");
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)"\n ORDER BY C.DESCRICAO,CL.DESCRICAO,QS.DESCRICAO,GO.DESCRICAO,GN.DESCRICAO,CF.INICIOVALIDADE DESC");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        StringBuilder sqlCount = new StringBuilder("SELECT COUNT(*) FROM (");
        sqlCount.append((CharSequence)sql);
        sqlCount.append(") COUNT");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query);
            LOGGER.debug(sqlCount.toString());
            LOGGER.debug(params.toString());
        }
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        List list = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CargoFaixaDTO.class));
        return new PageImpl(list, pageable, total.longValue());
    }

    public List<CargoFaixaDTO> findFaixas(CargoParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)CARGO));
        params.getCargo().ifPresent(item -> query.append("\n   AND CF.CARGO = :cargo "));
        params.getQuadro().ifPresent(item -> query.append("\n   AND CF.QUADROSALARIAL = :quadro "));
        params.getGrupo().ifPresent(item -> query.append("\n   AND CF.GRUPOOCUPACIONAL= :grupo "));
        params.getNivel().ifPresent(item -> query.append("\n   AND CF.NIVEL = :nivel "));
        query.append("\n ORDER BY GOF.FAIXA");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CargoFaixaDTO.class));
    }

    public List<CargoDTO> findCargosComFaixa(CargoParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)CARGOFAIXA));
        MapSqlParameterSource jdbcParameter = params.toJdbcParameter();
        params.getDescricao().ifPresent(item -> {
            query.append(" AND ${db.aise.schema}.tiraacento(LOWER(C.DESCRICAO)) LIKE '%' || ${db.aise.schema}.tiraacento(LOWER(:descricao)) || '%' ");
            jdbcParameter.addValue("descricao", item, 12);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)jdbcParameter, (RowMapper)new ElotechBeanPropertyRowMapper(CargoDTO.class));
    }
}

