/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.console.dto.RolesUsuarioDTO;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.domain.Menu;
import br.com.elotech.portaltransparencia.admportal.domain.Rota;
import br.com.elotech.portaltransparencia.admportal.domain.SubMenu;
import br.com.elotech.portaltransparencia.admportal.domain.Template;
import br.com.elotech.portaltransparencia.admportal.domain.TemplateExercicio;
import br.com.elotech.portaltransparencia.admportal.repository.RotaRepository;
import br.com.elotech.portaltransparencia.admportal.repository.TemplateRepository;
import br.com.elotech.portaltransparencia.admportal.service.TemplateResolver;
import br.com.elotech.portaltransparencia.admportal.utils.SecurityService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MenuDTO;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.ExercicioService;
import br.com.elotech.portaltransparencia.utils.EntidadeServiceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateService
extends CrudService<Template, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateService.class);
    private static final String PUBLICACOES = "Publica\u00e7\u00f5es";
    public static final Long EXERCICIO_2020 = 2020L;
    @Autowired
    private RotaRepository rotaRepository;
    @Autowired
    private ExercicioService exercicioService;
    @Autowired
    private EntidadeContabilidadeService entidadeContabilidadeService;
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private Optional<UsuarioClient> usuarioClient;
    @Autowired
    private EntidadeServiceUtils entidadeUtils;
    @Autowired
    private SecurityService securityService;
    private final TemplateResolver resolver = new TemplateResolver();

    public List<MenuDTO> generateTemplateByEntidadeExercicio(Long entidade, Long exercicio, List<MenuDTO> menus) {
        List templatesDiffZero = this.templateRepository.findTemplateDiffZeroByEntidade(entidade);
        if (templatesDiffZero != null && !templatesDiffZero.isEmpty()) {
            return this.loadTemplateByEntidadeExercicio(entidade, exercicio, menus);
        }
        Entidade entidadeTemplate = this.entidadeContabilidadeService.findOne(entidade);
        Template template = new Template();
        template.setDescricao(entidadeTemplate.getNome());
        template.getMenus().addAll(this.generateTemplateMenu(menus));
        template.getTemplateExercicios().addAll(this.generateTemplateExercicio(entidade));
        List menusDTOTemplate = this.generateMenuDTO(template.getMenus());
        this.generateTemplateMenuPublicacoes(menus, menusDTOTemplate, template.getMenus());
        this.templateRepository.save((Object)template);
        return menusDTOTemplate;
    }

    private void generateTemplateMenuPublicacoes(List<MenuDTO> menusDTO, List<MenuDTO> menusDTOTemplate, List<Menu> menusTemplate) {
        Optional<MenuDTO> menuPublicacoesDTO = menusDTO.stream().filter(menu -> PUBLICACOES.equals(menu.getTitle())).findFirst();
        Optional<MenuDTO> menuPublicacoesDTOTemplate = menusDTOTemplate.stream().filter(menu -> PUBLICACOES.equals(menu.getTitle())).findFirst();
        Optional<Menu> menuPublicacaoTemplate = menusTemplate.stream().filter(menu -> PUBLICACOES.equals(menu.getRotulo())).findFirst();
        if (menuPublicacoesDTO.isPresent() && menuPublicacoesDTOTemplate.isPresent()) {
            menuPublicacoesDTO.get().getSubMenu().forEach(subMenuTemp -> {
                MenuDTO subMenu = new MenuDTO();
                subMenu.setAtalho(subMenuTemp.getAtalho());
                subMenu.setDescription(subMenuTemp.getDescription());
                subMenu.setImage(subMenuTemp.getImage());
                subMenu.setId(subMenuTemp.getId());
                subMenu.setTitle(subMenuTemp.getTitle());
                SubMenu submenuTemplate = new SubMenu();
                submenuTemplate.setIcone(subMenuTemp.getImage());
                submenuTemplate.setRotulo(subMenuTemp.getTitle());
                submenuTemplate.setDescricao(subMenuTemp.getTitle());
                submenuTemplate.setAtivo(Boolean.TRUE);
                submenuTemplate.setOrdem(Long.valueOf(1L));
                subMenu.setRoute(subMenuTemp.getRoute());
                Rota rota = this.rotaRepository.findFirstByRotaIgnoreCase("/publicacoes");
                submenuTemplate.setRota(rota);
                String[] rotaPublicacaoSplit = subMenuTemp.getRoute().split("/");
                String idPublicacao = rotaPublicacaoSplit[rotaPublicacaoSplit.length - 1];
                if (!"publicacoes".equals(idPublicacao)) {
                    String urlAuxiliar = String.format("/%s", idPublicacao);
                    submenuTemplate.setUrlAuxiliar(urlAuxiliar);
                    subMenu.setUrlAuxiliar(urlAuxiliar);
                }
                ((MenuDTO)menuPublicacoesDTOTemplate.get()).getSubMenu().add(subMenu);
                ((Menu)menuPublicacaoTemplate.get()).getSubMenus().add(submenuTemplate);
            });
        }
    }

    public List<MenuDTO> loadTemplateByEntidadeExercicio(Long entidade, Long exercicio, List<MenuDTO> menus) {
        Optional<MenuDTO> menuTemplateCovid;
        Template resolved = this.findActiveTemplate(entidade, exercicio);
        List menusTemplate = this.generateMenuDTO(resolved.getMenus());
        if (exercicio.compareTo(EXERCICIO_2020) < 0 && (menuTemplateCovid = menusTemplate.stream().filter(menu -> "COVID-19".equals(menu.getTitle())).findFirst()).isPresent()) {
            menusTemplate.remove(menuTemplateCovid.get());
        }
        return menusTemplate;
    }

    public Template findActiveTemplate(Long entidade, Long exercicio) {
        List templatesEntidade = this.templateRepository.findTemplateDiffZeroByEntidade(entidade);
        try {
            return this.resolver.getResolved(entidade, exercicio, templatesEntidade);
        }
        catch (NoSuchElementException ex) {
            throw new NoSuchElementException("Nenhum template exerc\u00edcio registrado para o template padr\u00e3o desta entidade");
        }
    }

    public List<Template> findAllTemplatesByUsuario() {
        if (this.usuarioClient.isEmpty()) {
            List idsHabilitados = this.entidadeContabilidadeService.getEntidadesPermitidosAcesso(Boolean.TRUE).stream().map(Entidade::getId).collect(Collectors.toList());
            log.debug("Buscando todos templates de todas entidades habilitadas");
            List templatesEntidade = this.templateRepository.findByTemplateExercicioEntidadeIn(idsHabilitados);
            if (templatesEntidade.isEmpty()) {
                log.debug("Templates vazio");
            }
            return templatesEntidade.isEmpty() ? Collections.emptyList() : templatesEntidade;
        }
        List idsHabilitados = this.entidadeContabilidadeService.getEntidadesPermitidosAcesso(Boolean.TRUE).stream().map(Entidade::getId).collect(Collectors.toList());
        List templatesEntidade = this.templateRepository.findByTemplateExercicioEntidadeIn(idsHabilitados);
        if (templatesEntidade.isEmpty()) {
            log.debug("Templates vazio");
        }
        return templatesEntidade.isEmpty() ? Collections.emptyList() : templatesEntidade;
    }

    private boolean hasAdminRole(UUID userId, UUID entidadeId) {
        try {
            RolesUsuarioDTO rolesDto = ((UsuarioClient)this.usuarioClient.get()).findAllRolesByUsuarioAndEntidadeAndModulo(userId, entidadeId, Modulo.OXY_PORTAL_TRANSPARENCIA);
            return rolesDto.getClientRoles().stream().anyMatch(role -> role.getName().equalsIgnoreCase("administrador"));
        }
        catch (IllegalArgumentException e) {
            log.warn("M\u00f3dulo OXY Portal Transpar\u00eancia sem permiss\u00e3o para entidade {}", (Object)entidadeId);
            return false;
        }
    }

    private List<TemplateExercicio> generateTemplateExercicio(Long entidade) {
        List exercicios = this.exercicioService.getExercicios(entidade);
        Exercicio exercicioInicial = (Exercicio)exercicios.get(exercicios.size() - 1);
        ArrayList<TemplateExercicio> templateExercicios = new ArrayList<TemplateExercicio>();
        TemplateExercicio templateExercicio = new TemplateExercicio();
        templateExercicio.setEntidade(entidade);
        templateExercicio.setExercicioInicio(exercicioInicial.getId().getExercicio());
        templateExercicios.add(templateExercicio);
        return templateExercicios;
    }

    private List<Menu> generateTemplateMenu(List<MenuDTO> menusDTO) {
        Template templatePadrao = (Template)this.templateRepository.findOne((Object)0L);
        List menusTemplatePadrao = templatePadrao.getMenus();
        ArrayList<Menu> menus = new ArrayList<Menu>();
        menusTemplatePadrao.forEach(menuTemp -> {
            Menu menu = new Menu();
            menu.setAtalho(menuTemp.getAtalho());
            menu.setAtivo(this.getMenuAtivo(menuTemp, menusDTO));
            menu.setDescricao(menuTemp.getDescricao());
            menu.setIcone(menuTemp.getIcone());
            menu.setLinkExterno(menuTemp.getLinkExterno());
            menu.setOrdem(menuTemp.getOrdem());
            menu.setRota(menuTemp.getRota());
            menu.setRotulo(menuTemp.getRotulo());
            menuTemp.getSubMenus().forEach(subMenuTemp -> {
                SubMenu subMenu = new SubMenu();
                subMenu.setAtalho(subMenuTemp.getAtalho());
                subMenu.setAtivo(this.getSubMenuAtivo(subMenuTemp, menusDTO));
                subMenu.setDescricao(subMenuTemp.getDescricao());
                subMenu.setIcone(subMenuTemp.getIcone());
                subMenu.setLinkExterno(subMenuTemp.getLinkExterno());
                subMenu.setOrdem(subMenuTemp.getId());
                subMenu.setRota(subMenuTemp.getRota());
                subMenu.setRotulo(subMenuTemp.getRotulo());
                menu.getSubMenus().add(subMenu);
            });
            menus.add(menu);
        });
        return menus;
    }

    private Boolean getSubMenuAtivo(SubMenu subMenuTemp, List<MenuDTO> menusDTO) {
        Optional<MenuDTO> findFirst = menusDTO.stream().filter(menu -> menu.getSubMenu().stream().anyMatch(subMenu -> subMenu.getTitle().equals(subMenuTemp.getRotulo()))).findFirst();
        return findFirst.isPresent();
    }

    private Boolean getMenuAtivo(Menu menuTemp, List<MenuDTO> menusDTO) {
        Optional<MenuDTO> findFirst = menusDTO.stream().filter(menu -> menu.getTitle().equals(menuTemp.getRotulo())).findFirst();
        return findFirst.isPresent();
    }

    private List<MenuDTO> generateMenuDTO(List<Menu> menus) {
        ArrayList<MenuDTO> menusDTO = new ArrayList<MenuDTO>();
        menus.forEach(menu -> {
            if (menu.getAtivo().booleanValue()) {
                MenuDTO menuDTO = new MenuDTO();
                menuDTO.setAtalho(menu.getAtalho());
                menuDTO.setSubtitle(menu.getDescricao());
                menuDTO.setImage(menu.getIcone());
                menuDTO.setLink(menu.getLinkExterno());
                menuDTO.setId(menu.getOrdem());
                if (menu.getRota() != null) {
                    menuDTO.setRoute(menu.getRota().getRota());
                }
                menuDTO.setTitle(menu.getRotulo());
                menuDTO.setUrlAuxiliar(menu.getUrlAuxiliar());
                if (menu.getSubMenus() != null && !menu.getSubMenus().isEmpty()) {
                    menuDTO.getSubMenu().addAll(this.getSubMenuDTO(menu));
                }
                menusDTO.add(menuDTO);
            }
        });
        return menusDTO;
    }

    private List<MenuDTO> getSubMenuDTO(Menu menu) {
        ArrayList<MenuDTO> subMenus = new ArrayList<MenuDTO>();
        menu.getSubMenus().forEach(subMenu -> {
            if (subMenu.getAtivo().booleanValue()) {
                MenuDTO subMenuDTO = new MenuDTO();
                subMenuDTO.setAtalho(subMenu.getAtalho());
                subMenuDTO.setSubtitle(subMenu.getDescricao());
                subMenuDTO.setImage(subMenu.getIcone());
                subMenuDTO.setLink(subMenu.getLinkExterno());
                subMenuDTO.setId(subMenu.getOrdem());
                if (subMenu.getRota() != null) {
                    subMenuDTO.setRoute(subMenu.getRota().getRota());
                    subMenuDTO.setUrlAuxiliar(subMenu.getUrlAuxiliar());
                }
                subMenuDTO.setTitle(subMenu.getRotulo());
                subMenus.add(subMenuDTO);
            }
        });
        return subMenus;
    }
}

