/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoRepository;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoSubGrupoRepository;
import br.com.elotech.portaltransparencia.admportal.service.PublicacaoGrupoService;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupoEntidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoGrupoEntidadePK;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupo;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoGrupoEntidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoGrupoRepository;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class PublicacaoGrupoEntidadeService
extends CrudService<PublicacaoGrupoEntidade, PublicacaoGrupoEntidadePK> {
    private final PublicacaoGrupoEntidadeRepository repository;
    private final PublicacaoRepository publicacaoRepository;
    private final PublicacaoSubGrupoRepository pubSubGrupoRepository;
    private final PublicacaoGrupoService grupoService;
    private final PublicacaoGrupoRepository grupoRepository;

    protected void beforeSave(PublicacaoGrupoEntidade entity, Authentication authentication) {
        PublicacaoGrupo grupo = entity.getId().getGrupo();
        if (Objects.nonNull(grupo.getId())) {
            this.grupoService.findById((Serializable)grupo.getId()).ifPresent(publicacaoGrupo -> {
                if (!publicacaoGrupo.getDescricao().equals(grupo.getDescricao())) {
                    this.validateVinculoDescricaoExists(entity);
                }
            });
        } else {
            this.validateVinculoDescricaoExists(entity);
        }
        PublicacaoGrupo grupoAtualizado = this.grupoService.findByDescricaoOrCreate(entity.getId().getGrupo());
        Optional.ofNullable(entity.getMostraWeb()).ifPresent(arg_0 -> ((PublicacaoGrupo)grupoAtualizado).setMostraWeb(arg_0));
        Optional.ofNullable(entity.getId()).map(PublicacaoGrupoEntidadePK::getGrupo).map(PublicacaoGrupo::getFiltrarPorExercicio).ifPresent(arg_0 -> ((PublicacaoGrupo)grupoAtualizado).setFiltrarPorExercicio(arg_0));
        Optional.ofNullable(entity.getId()).ifPresent(id -> id.setGrupo(grupoAtualizado));
        super.beforeSave((EloEntity)entity, authentication);
    }

    private void validateVinculoDescricaoExists(PublicacaoGrupoEntidade entity) {
        PublicacaoGrupo grupo = entity.getId().getGrupo();
        this.repository.findByIdEntidadeIdAndIdGrupoDescricao(entity.getId().getEntidade().getId(), grupo.getDescricao()).ifPresent(found -> {
            throw new IllegalArgumentException(String.format("O Grupo [%s] j\u00e1 existe para a Entidade [%s].", found.getId().getGrupo().getDescricao(), entity.getId().getEntidade().getId()));
        });
    }

    protected void beforeDelete(PublicacaoGrupoEntidade entity, Authentication authentication) {
        if (this.publicacaoRepository.existsByGrupoIdIn(this.pubSubGrupoRepository.findByIdGrupoRelatorio(entity.getId().getGrupo().getId()).stream().map(PublicacaoSubGrupo::getId).collect(Collectors.toList()))) {
            throw new EloValidationException("Existem publica\u00e7\u00f5es para o Grupo em quest\u00e3o.");
        }
    }

    public void saveAll(List<PublicacaoGrupoEntidade> publicacaoGrupoEntidadeList) {
        List<PublicacaoGrupo> publicacaoGrupos = publicacaoGrupoEntidadeList.stream().map(grupo -> grupo.getId().getGrupo()).toList();
        this.grupoRepository.saveAll(publicacaoGrupos);
        this.repository.saveAll(publicacaoGrupoEntidadeList);
    }

    @Generated
    public PublicacaoGrupoEntidadeService(PublicacaoGrupoEntidadeRepository repository, PublicacaoRepository publicacaoRepository, PublicacaoSubGrupoRepository pubSubGrupoRepository, PublicacaoGrupoService grupoService, PublicacaoGrupoRepository grupoRepository) {
        this.repository = repository;
        this.publicacaoRepository = publicacaoRepository;
        this.pubSubGrupoRepository = pubSubGrupoRepository;
        this.grupoService = grupoService;
        this.grupoRepository = grupoRepository;
    }
}

